package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaDropdownButtonProperties extends AbstractMetaObject implements IPropertyMerger<MetaDropdownButtonProperties>{
	/** 图标 */
	private String icon = "";
	/** 点击事件 */
	private MetaBaseScript onClick = null;
	/** 下拉项集合 */
	private MetaDropdownItemCollection itemCollection = new MetaDropdownItemCollection();
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( onClick != null ) {
			list.add(onClick);
		}
		if ( itemCollection != null ) {
			list.add(itemCollection);
		}
	}
	
	/**单独添加class名*/
	private String cssClass = "";
	
	/**
	 * 设置图标
	 * @param icon 图标
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}
	
	/**
	 * 取得图标
	 * @return 图标
	 */
	public String getIcon() {
		return this.icon;
	}
	
	public MetaBaseScript getOnClick() {
		return onClick;
	}

	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}

	/**
	 * 设置下拉项集合
	 * @param itemCollection 下拉项集合
	 */
	public void setItemCollection(MetaDropdownItemCollection itemCollection) {
		this.itemCollection = itemCollection;
	}
	
	/**
	 * 取得下拉项集合
	 * @return 下拉项集合
	 */
	public MetaDropdownItemCollection getItemCollection() {
		return this.itemCollection;
	}
	
	/**
	 * 添加class
	 * @return class
	 */
	public String getCssClass() {
		return cssClass;
	}
	
	/**
	 * 添加class
	 * @param cssClass
	 */
	public void setCssClass(String cssClass) {
		this.cssClass = cssClass;
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = itemCollection.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if ( resultMetaObject == null ) {
			if ( MetaConstants.Event_OnClick.equals(tagName) ) {
				onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
				resultMetaObject = onClick;
			}
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDropdownButtonProperties newObject = new MetaDropdownButtonProperties();
		newObject.setIcon(icon);
		newObject.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());
		newObject.setItemCollection(itemCollection == null ? null : (MetaDropdownItemCollection)itemCollection.clone());
		newObject.setCssClass(cssClass);
		return newObject;
	}
	
	@Override
	public void merge(MetaDropdownButtonProperties properties) {
		if( this.icon == null){
			this.icon = properties.getIcon();
		}
		if( this.itemCollection == null){
			this.itemCollection = properties.getItemCollection();
		}
		if( this.cssClass == null){
			this.cssClass = properties.getCssClass();
		}
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDropdownButtonProperties();
	}
}
