package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.grid.MetaCellCustomData;

public class MetaCustomProperties extends AbstractMetaObject {
	/** 定制数据对象*/
	private MetaCellCustomData customData = null;
	/** 指定视图的工厂*/
	private String cellViewFactory = "";
	/** 视图工厂的配置*/
	private String viewFactoryConfig = "";

	public MetaCustomProperties() {
		
	}
	
	/**
	 * 获取定制数据对象
	 * @return 定制数据对象
	 */
	public MetaCellCustomData getCustomData() {
		return customData;
	}

	/**
	 * 设置定制数据对象
	 * @param customData 定制数据对象
	 */
	public void setCustomData(MetaCellCustomData customData) {
		this.customData = customData;
	}

	/**
	 * 获取提供视图显示的工厂
	 * @return 工厂
	 */
	public String getCellViewFactory() {
		return cellViewFactory;
	}

	/**
	 * 设置提供视图显示的工厂
	 * @param cellViewFactory 工厂
	 */
	public void setCellViewFactory(String cellViewFactory) {
		this.cellViewFactory = cellViewFactory;
	}

	/**
	 * 取得工厂配置
	 * @return 工厂配置
	 */
	public String getViewFactoryConfig() {
		return viewFactoryConfig;
	}

	/**
	 * 设置工厂配置
	 * @param viewFactoryConfig 工厂配置
	 */
	public void setViewFactoryConfig(String viewFactoryConfig) {
		this.viewFactoryConfig = viewFactoryConfig;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if (customData != null) {
			list.add(customData);
		}
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaCellCustomData.TAG_NAME.equals(tagName)) {
			customData = new MetaCellCustomData();
			resultMetaObject = customData;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCustomProperties newObject = (MetaCustomProperties) newInstance();
		newObject.setCellViewFactory(cellViewFactory);
		newObject.setViewFactoryConfig(viewFactoryConfig);
		newObject.setCustomData(customData == null ? null : (MetaCellCustomData) customData.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCustomProperties();
	}
	
	/*@Override
	protected void divideSubMetaDiffAction(AbstractMetaObject newMeta, MetaDiffNode metaDiffNode, MetaDiff metaDiff, IDiffMetaEnv env) throws Exception {
		MetaCustomProperties meta = (MetaCustomProperties) newMeta;
		MetaDiffUtil2.diffOnlyUpdate(customData, meta.getCustomData(), metaDiffNode, env);
	}
	
	@Override
	protected void mergeDiffSelf(MetaDiff metaDiff, MetaDiffNode metaDiffNode, IMetaEnv env) throws Exception {
		metaDiffNode.mergeDiff(new IMergeDiffAction(){
			@Override
			public void mergeBase(AbstractMetaObject meta) throws Exception {}

			@Override
			public void mergeUpdate(AbstractMetaObject meta) {
				switch (meta.getTagName()) {
				case MetaCellCustomData.TAG_NAME:
					setCustomData((MetaCellCustomData) meta.clone());
					break;
				}
			}

			@Override
			public void mergeDelete(KeyPairMetaObject meta) {}

			@Override
			public void mergeAdd(KeyPairMetaObject meta) {}

			@Override
			public void mergeSort(MetaSort meta) {}
		});
	}
*/
}
