package com.bokesoft.yigo.meta.form.component.control.map;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.MapDrawType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaPara;
import com.bokesoft.yigo.meta.common.MetaParas;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

public class MetaMapDraw extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_MAP;

	@Override
	public int getControlType() {
		return ControlType.MAP;
	}

	/** 地图类型 */
	private Integer type = MapDrawType.Baidu;
	
	/** 地图url*/
	private String url = null;
	/** 地图参数*/
	private MetaParas paras = null;
	/** 地图事件集合*/
	private MetaMapEventCollection eventCollection = null;
	
	public MetaMapDraw() {
		super();
		paras = new MetaParas();
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}
	
	/**
	 * 根据标识获取对应地图事件
	 * @param key 事件标识
	 * @return 对应地图事件
	 */
	public MetaBaseScript getEvent(String key){
		if(eventCollection == null){
			return null;
		}
		MetaMapEvent event = eventCollection.get(key);
		return event;
	}
	
	/**
	 * 获取参数集合
	 * @return 参数集合
	 */
	public MetaParas getParas() {
		return paras;
	}
	
	/**
	 * 根据标识获取对应的参数
	 * @param key 事件标识
	 * @return 对应参数
	 */
	public Object getPara(String key){
		if(paras == null){
			return null;
		}
		MetaPara p = paras.get(key);
		if(p == null){
			return null;
		}
		return p.getValue();
	}
	
	/**
	 * 根据标识获取对应的参数
	 * @param key 事件标识
	 * @param defValue 默认值，即取不到标识对应参数时的返回值
	 * @return 对应参数
	 */
	public Object getPara(String key, Object defValue){
		Object object = getPara(key);
		return object == null ? defValue : object;
	}

	/**
	 * 设置参数集合
	 * @param paras 参数集合
	 */
	public void setParas(MetaParas paras) {
		this.paras = paras;
	}
	
	/**
	 * 取得事件集合
	 * @return 事件集合
	 */
	public MetaMapEventCollection getEventCollection() {
		return eventCollection;
	}

	/**
	 * 设置事件集合
	 * @param eventCollection 事件集合
	 */
	public void setEventCollection(MetaMapEventCollection eventCollection) {
		this.eventCollection = eventCollection;
	}

	/**
	 * 设置地图url
	 * @param url 地图url
	 */
	public void setURL(String url){
		this.url = url;
	}
	
	/**
	 * 获取地图url
	 * @return 地图url
	 */
	public String getURL(){
		return this.url;
	}
	
	
	/**
	 * 设置地图类型
	 * @param type 地图类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}

	/**
	 * 获取地图类型
	 * @return 地图类型
	 */
	public Integer getType() {
		return type;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new Object[] {
				paras,eventCollection
		});
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMapDraw();
	}

	@Override
	public AbstractMetaObject getProperties() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaParas.TAG_NAME.equals(tagName) ) {
			paras = new MetaParas();
			resultMetaObject = paras;
		}else if(MetaMapEventCollection.TAG_NAME.equals(tagName)){
			eventCollection = new MetaMapEventCollection();
			resultMetaObject = eventCollection;
		}
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaMapDraw newObject = (MetaMapDraw) super.clone();
		newObject.setType(type);
		newObject.setURL(url);
		newObject.setParas(paras == null ? null : (MetaParas)paras.clone());
		newObject.setEventCollection(eventCollection == null ? null : (MetaMapEventCollection)eventCollection.clone());
		return newObject;
	}
}
