package com.bokesoft.yigo.meta.form.component.control.gantt;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

/**
 * 甘特图的表结构
 */
public class MetaGanttTable extends AbstractMetaObject {

	public static final String TAG_NAME = "GanttTable";

	/** 表标识 */
	private String tableKey = "";

	/** 允许拖拽调整图形 */
	private Boolean dragProgress = null;

	/** 列定义集合 */
	private MetaGanttColumnCollection columnCollection = null;

	/** 行定义集合 */
	private MetaGanttRowCollection rowCollection = null;

	/** 关系数据来源 */
	private MetaRelationship relationship = null;

	/** 行点击事件*/
	private MetaBaseScript rowClick = null;

	/** 行双击事件*/
	private MetaBaseScript rowDblClick = null;

	/**
	 * 设置行点击事件
	 * @param rowClick
	 */
	public void setRowClick(MetaBaseScript rowClick) {
		this.rowClick = rowClick;
	}

	/**
	 * 获取行点击事件
	 * @return
	 */
	public MetaBaseScript getRowClick() {
		return rowClick;
	}

	/**
	 * 设置行双击事件
	 * @param rowDblClick
	 */
	public void setRowDblClick(MetaBaseScript rowDblClick) {
		this.rowDblClick = rowDblClick;
	}

	/**
	 * 获取行双击事件
	 * @return
	 */
	public MetaBaseScript getRowDblClick() {
		return rowDblClick;
	}

	/**
	 * 设置表标识
	 * 
	 * @param tableKey
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	/**
	 * 获取表标识
	 * 
	 * @return
	 */
	public String getTableKey() {
		return this.tableKey;
	}

	/**
	 * 获取是否允许拖拽
	 *
	 * @return
	 */
	public Boolean getDragProgress() {
		return dragProgress;
	}

	/**
	 * 设置是否允许拖拽
	 *
	 * @param dragProgress
	 */
	public void setDragProgress(Boolean dragProgress) {
		this.dragProgress = dragProgress;
	}

	/**
	 * 获取关系数据
	 *
	 * @return
	 */
	public MetaRelationship getRelationship() {
		return relationship;
	}

	/**
	 * 设置关系数据
	 *
	 * @param relationship
	 */
	public void setRelationship(MetaRelationship relationship) {
		this.relationship = relationship;
	}

	/**
	 * 设置列定义集合
	 * 
	 * @param columnCollection
	 */
	public void setColumnCollection(MetaGanttColumnCollection columnCollection) {
		this.columnCollection = columnCollection;
	}

	/**
	 * 获取列定义集合
	 * 
	 * @return
	 */
	public MetaGanttColumnCollection getColumnCollection() {
		return this.columnCollection;
	}

	/**
	 * 设置行定义集合
	 *
	 * @param rowCollection 行定义集合
	 */
	public void setRowCollection(MetaGanttRowCollection rowCollection) {
		this.rowCollection = rowCollection;
	}

	/**
	 * 获取列定义集合
	 *
	 * @return 行定义集合
	 */
	public MetaGanttRowCollection getRowCollection() {
		return this.rowCollection;
	}


	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		this.addAll(list, new Object[] { this.columnCollection, this.rowCollection, this.relationship, this.rowClick, this.rowDblClick });
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject metaObject = null;
		if (MetaGanttColumnCollection.TAG_NAME.equals(tagName)) {
			this.columnCollection = new MetaGanttColumnCollection();
			metaObject = this.columnCollection;
		} else if (MetaGanttRowCollection.TAG_NAME.equals(tagName)) {
			this.rowCollection = new MetaGanttRowCollection();
			metaObject = this.rowCollection;
		} else if (MetaRelationship.TAG_NAME.equals(tagName)) {
			this.relationship = new MetaRelationship();
			metaObject = this.relationship;
		} else if (MetaConstants.Event_RowClick.equals(tagName)) {
			this.rowClick = new MetaBaseScript(MetaConstants.Event_RowClick);
			metaObject = this.rowClick;
		} else if (MetaConstants.Event_RowDblClick.equals(tagName)) {
			this.rowDblClick = new MetaBaseScript(MetaConstants.Event_RowDblClick);
			metaObject = this.rowDblClick;
		}

		return metaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaGanttTable newObject = new MetaGanttTable();
		newObject.setTableKey(this.tableKey);
		newObject.setDragProgress(this.dragProgress);
		newObject.setColumnCollection(
				this.columnCollection == null ? null : (MetaGanttColumnCollection) this.columnCollection.clone());
		newObject.setRowCollection(
				this.rowCollection == null ? null : (MetaGanttRowCollection) this.rowCollection.clone());
		newObject.setRelationship(this.relationship == null ? null : (MetaRelationship) this.relationship.clone());
		newObject.setRowClick(rowClick == null ? null : (MetaBaseScript) this.rowClick.clone());
		newObject.setRowDblClick(rowDblClick == null ? null : (MetaBaseScript) this.rowDblClick.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGanttTable();
	}

}
