package com.bokesoft.yigo.meta.form.component.control.gantt;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

import java.util.LinkedList;

/**
 * 甘特图行对象集合
 */
public class MetaGanttRowCollection extends GenericNoKeyCollection<MetaGanttRow> {

	public static final String TAG_NAME = "GanttRowCollection";

	/** id */
	private String shapeId = "";

	/** 类型 */
	private String type = "";

	/** 显示文本 */
	private String title = "";

	/** 耗时 */
	private String duration = "";

	/** 进度 */
	private String progress = "";

	/** 父级 */
	private String parent = "";

	/**
	 * 获取显示文本
	 *
	 * @return
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * 设置显示文本
	 *
	 * @param title
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * 获取id
	 *
	 * @return
	 */
	public String getShapeId() {
		return shapeId;
	}

	/**
	 * 设置id
	 *
	 * @param shapeId
	 */
	public void setShapeId(String shapeId) {
		this.shapeId = shapeId;
	}

	/**
	 * 获取类型
	 *
	 * @return
	 */
	public String getType() {
		return type;
	}

	/**
	 * 设置类型
	 *
	 * @param type
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * 获取耗时
	 *
	 * @return
	 */
	public String getDuration() {
		return duration;
	}

	/**
	 * 设置耗时
	 *
	 * @param duration
	 */
	public void setDuration(String duration) {
		this.duration = duration;
	}

	/**
	 * 获取进度
	 *
	 * @return
	 */
	public String getProgress() {
		return progress;
	}

	/**
	 * 设置进度
	 *
	 * @param progress
	 */
	public void setProgress(String progress) {
		this.progress = progress;
	}

	/**
	 * 获取父id
	 *
	 * @return
	 */
	public String getParent() {
		return parent;
	}

	/**
	 * 设置父id
	 *
	 * @param parent
	 */
	public void setParent(String parent) {
		this.parent = parent;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject metaObject = null;
		if (MetaGanttRow.TAG_NAME.equals(tagName)) {
			MetaGanttRow ganttRow = new MetaGanttRow();
			metaObject = ganttRow;
			this.add(ganttRow);
		}

		return metaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGanttRowCollection();
	}

}
