package com.bokesoft.yigo.meta.form.component.control.gantt;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

/**
 * 甘特图
 */
public class MetaGantt extends MetaComponent {

	public static final String TAG_NAME = ControlType.STR_GANTT;

	/** 表结构 */
	private MetaGanttTable ganttTable = null;

	/**
	 * 获取表结构
	 * 
	 * @return
	 */
	public MetaGanttTable getGanttTable() {
		return this.ganttTable;
	}

	/**
	 * 设置表结构
	 * 
	 * @param ganttTable
	 */
	public void setGanttTable(MetaGanttTable ganttTable) {
		this.ganttTable = ganttTable;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.GANTT;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGantt();
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaGanttTable.TAG_NAME.equals(tagName)) {
			this.ganttTable = new MetaGanttTable();
			resultMetaObject = this.ganttTable;
		}

		if (resultMetaObject == null) {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}

		if (resultMetaObject != null) {
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaGantt newObject = (MetaGantt) super.clone();
		newObject.setGanttTable(ganttTable == null ? null : (MetaGanttTable) ganttTable.clone());
		return newObject;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		this.addAll(list, new Object[] { this.ganttTable });
	}

}
