package com.bokesoft.yigo.meta.form.component.control.editview;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowActionCollection;

public class MetaEditViewRow extends AbstractMetaObject implements IPropertyMerger<MetaEditViewRow> {

	/** 间隔样式，目前支持值：""（默认）、"Solid"（实线，四周都有）、"None"（无边框）、
	 * "None Solid"（前一个代表上下，后一个代表左右）、
	 * "Solid None None Solid"（四个按方位，上右下左来设置）。*/
	private String separatorStyle = "";
	/** 边框圆角大小,只对solid有效 */
	private Integer separatorRadius = -1;
	/** 间隔颜色 */
	private String separatorColor = "";
	/** 间隔距离左边界的距离 */
	private DefSize separatorOffset = null;
	/** 顶边界 */
	private String topMargin = "";
	/** 行间距*/
	private Integer rowGap = 0;
	/** 选中颜色 */
	private String selectColor = "";
	/** 高亮颜色*/
	private String highlightColor = "";
	/** 背景颜色*/
	private String backColor = "";
	/** 行操作集合 */
	private MetaRowActionCollection actionCollection;

	/**
	 * 获取间隔样式
	 * @return 间隔样式，目前支持值：""（默认）、"Solid"（实线，四周都有）、"None"（无边框）、
	 * "None Solid"（前一个代表上下，后一个代表左右）、
	 * "Solid None None Solid"（四个按方位，上右下左来设置）。
	 */
	public String getSeparatorStyle() {
		return separatorStyle;
	}

	/**
	 * 设置间隔样式
	 * @param separatorStyle 间隔样式，目前支持值：""（默认）、"Solid"（实线，四周都有）、"None"（无边框）、
	 * "None Solid"（前一个代表上下，后一个代表左右）、
	 * "Solid None None Solid"（四个按方位，上右下左来设置）。
	 */
	public void setSeparatorStyle(String separatorStyle) {
		this.separatorStyle = separatorStyle;
	}
	
	/**
	 * 取得边框圆角大小
	 * @return 大小
	 */
	public Integer getSeparatorRadius() {
		return this.separatorRadius;
	}
	
	/**
	 * 设置边框圆角大小
	 * @param separatorRadius 大小
	 */
	public void setSeparatorRadius(Integer separatorRadius) {
		this.separatorRadius = separatorRadius;
	}
	
	/**
	 * 获取行间距
	 * @return
	 */
	public Integer getRowGap() {
		return rowGap;
	}

	/**
	 * 设置行间距
	 * @param rowGap
	 */
	public void setRowGap(Integer rowGap) {
		this.rowGap = rowGap;
	}

	/**
	 * 获取间隔颜色
	 * @return 间隔样式
	 */
	public String getSeparatorColor() {
		return separatorColor;
	}

	/**
	 * 设置间隔颜色
	 * @param separatorColor 间隔颜色
	 */
	public void setSeparatorColor(String separatorColor) {
		this.separatorColor = separatorColor;
	}
	
	/**
	 * 设置间隔距离左边界的距离
	 * @param separatorOffset 间隔距离左边界的距离
	 */
	public void setSeparatorOffset(DefSize separatorOffset) {
		this.separatorOffset = separatorOffset;
	}
	
	/**
	 * 获取间隔距离左边界的距离
	 * @return 间隔距离左边界的距离
	 */
	public DefSize getSeparatorOffset() {
		return separatorOffset;
	}

	/**
	 * 获取顶边距
	 * @return 顶边距
	 */
	public String getTopMargin() {
		return topMargin;
	}

	/**
	 * 设置顶边距
	 * @param topMargin 顶边距
	 */
	public void setTopMargin(String topMargin) {
		this.topMargin = topMargin;
	}
	
	/**
	 * 获取选中颜色
	 * @return 选中颜色
	 */
	public String getSelectColor() {
		return selectColor;
	}
	
	/**
	 * 设置选中颜色
	 * @param selectColor 选中颜色
	 */
	public void setSelectColor(String selectColor) {
		this.selectColor = selectColor;
	}
	
	/**
	 * 获取高亮颜色
	 * @return 高亮颜色
	 */
	public String getHighlightColor() {
		return highlightColor;
	}
	
	/**
	 * 设置高亮颜色
	 * @param highlightColor 高亮颜色
	 */
	public void setHighlightColor(String highlightColor) {
		this.highlightColor = highlightColor;
	}
	
	/**
	 * 获取背景色
	 * @return 背景色
	 */
	public String getBackColor() {
		return backColor;
	}
	
	/**
	 * 设置背景色
	 * @param backColor 背景色
	 */
	public void setBackColor(String backColor) {
		this.backColor = backColor;
	}
	
	/**
	 * 获取行操作集合
	 * @return 行操作集合
	 */
	public MetaRowActionCollection getActionCollection() {
		return actionCollection;
	}
	
	/**
	 * 设置行操作集合
	 * @param actionCollection 行操作集合
	 */
	public void setActionCollection(MetaRowActionCollection actionCollection) {
		this.actionCollection = actionCollection;
	}

	public static final String TAG_NAME = "EditViewRow";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { actionCollection });
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaRowActionCollection.TAG_NAME)) {
			actionCollection = new MetaRowActionCollection();
			resultMetaObject = actionCollection;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaEditViewRow newObj = new MetaEditViewRow();
		newObj.setSeparatorColor(separatorColor);
		newObj.setSeparatorStyle(separatorStyle);
		newObj.setSeparatorOffset(separatorOffset);
		newObj.setTopMargin(topMargin);
		newObj.setSelectColor(selectColor);
		newObj.setHighlightColor(highlightColor);
		newObj.setBackColor(backColor);
		newObj.setRowGap(rowGap);
		newObj.setActionCollection(actionCollection == null ? null : (MetaRowActionCollection)actionCollection.clone());
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaEditViewRow();
	}
	
	@Override
	public void merge(MetaEditViewRow metaRow) {
		if( this.separatorStyle == null ) {
			this.separatorStyle = metaRow.getSeparatorStyle();
		}
		if( this.separatorColor == null ) {
			this.separatorColor = metaRow.getSeparatorColor();
		}
		if( this.separatorRadius == -1 ) {
			this.separatorRadius = metaRow.getSeparatorRadius();
		}
		if( this.separatorOffset == null ) {
			this.separatorOffset = metaRow.getSeparatorOffset() == null ? null : metaRow.getSeparatorOffset().clone();
		}
		if( this.topMargin == null ) {
			this.topMargin = metaRow.getTopMargin();
		}
		if( this.selectColor == null ) {
			this.selectColor = metaRow.getSelectColor();
		}
		if( this.highlightColor == null ) {
			this.highlightColor = metaRow.getHighlightColor();
		}
		if( this.rowGap == -1 ) {
			this.rowGap = metaRow.getRowGap();
		}
		if( this.backColor == null ) {
			this.backColor = metaRow.getBackColor();
		}
		if( this.actionCollection == null ) {
			this.actionCollection = metaRow.getActionCollection() == null ? null : (MetaRowActionCollection)metaRow.getActionCollection().clone();
		}
	}
}
