package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.ImageSourceType;
import com.bokesoft.yigo.common.def.UploadProgressType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaVideoPlayerProperties;

/**
 * 视频播放组件配置对象
 * 
 * @author chenzs
 *
 */
public class MetaVideoPlayer extends MetaComponent {

	private MetaVideoPlayerProperties properties = new MetaVideoPlayerProperties();

	public MetaVideoPlayer() {
		super();
	}

	/**
	 * 获取显示上传进度指示器的样式
	 *
	 * @return 显示上传进度指示器的样式，取值范围为{@link UploadProgressType}
	 */
	public Integer getUploadProgress() {
		return properties.getUploadProgress();
	}

	/**
	 * 设置显示上传进度指示器的样式，取值范围为{@link UploadProgressType}
	 *
	 * @param uploadProgress
	 *            显示上传进度指示器的样式，取值范围为{@link UploadProgressType}
	 */
	public void setUploadProgress(Integer uploadProgress) {
		properties.setUploadProgress(uploadProgress);
	}

	/**
	 * 获取视频来源类型
	 *
	 * @return 视频来源类型，取值范围为{@link ImageSourceType}
	 */
	public Integer getSourceType() {
		return this.properties.getSourceType();
	}

	/**
	 * 设置视频相对路径，仅{@link #getSourceType()}为{@link ImageSourceType#RESOURCE}时生效
	 *
	 * @param path
	 *            视频相对路径
	 */
	public void setPath(String path) {
		this.properties.setPath(path);
	}

	/**
	 * 获取视频相对路径，仅{@link #getSourceType()}为{@link ImageSourceType#RESOURCE}时生效
	 *
	 * @return 视频相对路径
	 */
	public String getPath() {
		return this.properties.getPath();
	}

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_VIDEOPLAYER;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.VIDEOPLAYER;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaVideoPlayer newObject = (MetaVideoPlayer) super.clone();
		newObject.setProperties((MetaVideoPlayerProperties) properties.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaVideoPlayer();
	}

	@Override
	public MetaVideoPlayerProperties getProperties() {
		return properties;
	}

	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaVideoPlayerProperties) properties;
	}
}
