package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNoticeBarProperties;

public class MetaNoticeBar extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_NOTICEBAR;
	protected MetaNoticeBarProperties properties;

	public MetaNoticeBar(){
		properties = new MetaNoticeBarProperties();
	}
	

	/**
	 * 获取前置图标
	 * @return 前置图标
	 */
	public String getPreIcon() {
		return properties.getPreIcon();
	}

	/**
	 * 设置前置图标
	 * @param preIcon 前置图标
	 */
	public void setPreIcon(String preIcon) {
		properties.setPreIcon(preIcon);
	}

	/**
	 * 获取操作图标
	 * @return 操作图标
	 */
	public String getActionIcon() {
		return properties.getActionIcon();
	}

	/**
	 * 设置操作图标
	 * @param actionIcon 操作图标
	 */
	public void setActionIcon(String actionIcon) {
		properties.setActionIcon(actionIcon);
	}

	/**
	 * 获取是否滚动
	 * @return 是否滚动
	 */
	public Boolean getScrollable() {
		return properties.getScrollable();
	}

	/**
	 * 设置是否滚动
	 * @param scrollable 是否滚动
	 */
	public void setScrollable(Boolean scrollable) {
		properties.setScrollable(scrollable);
	}

	/**
	 * 获取是否单行
	 * @return 是否单行
	 */
	public Boolean getSingleLine() {
		return properties.getSingleLine();
	}

	/**
	 * 设置是否单行
	 * @param singleLine 是否单行
	 */
	public void setSingleLine(Boolean singleLine) {
		properties.setSingleLine(singleLine);
	}

	/**
	 * 获取滚动方向
	 * @return 滚动方向
	 */
	public Integer getOrientation() {
		return properties.getOrientation();
	}

	/**
	 * 设置滚动方向
	 * @param orientation 滚动方向
	 */
	public void setOrientation(Integer orientation) {
		properties.setOrientation(orientation);
	}

	/**
	 * 获取操作事件
	 * @return 操作事件
	 */
	public MetaBaseScript getAction() {
		return properties.getAction();
	}

	/**
	 * 设置操作事件
	 * @param action 操作事件
	 */
	public void setAction(MetaBaseScript action) {
		properties.setAction(action);
	}

	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaNoticeBarProperties) properties;
	}
	
	@Override
	public MetaNoticeBarProperties getProperties() {
		return this.properties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.NOTICEBAR;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaNoticeBar newObject = (MetaNoticeBar)super.clone();
		newObject.setProperties((MetaNoticeBarProperties)properties.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNoticeBar();
	}
}

