package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHyperLinkProperties;

/**
 * 超链接配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaHyperLink extends MetaComponent {
	/** 目标显示方式——新窗口 */
	public static final int TARGETSHOWTYPE_NEW = 0;
	/** 目标显示方式——新Tab页 */
	public static final int TARGETSHOWTYPE_NEWTAB = 1;
	/** 目标显示方式——当前页 */
	public static final int TARGETSHOWTYPE_CURRENT = 2;
	
	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_HYPERLINK;

	private MetaHyperLinkProperties properties = new MetaHyperLinkProperties();

	/**
	 * 设置点击事件
	 * 
	 * @param onClick
	 *            点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.properties.setOnClick(onClick);
	}

	/**
	 * 获取点击事件
	 * 
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return this.properties.getOnClick();
	}

	/**
	 * 设置引用地址
	 * 
	 * @param url
	 *            引用地址
	 */
	public void setURL(String url) {
		this.properties.setURL(url);
	}

	/**
	 * 获取引用地址
	 * 
	 * @return 引用地址
	 */
	public String getURL() {
		return this.properties.getURL();
	}

	/**
	 * 设置目标显示方式，取值为新窗口(New)、当前(Current)、新Tab页(NewTab)
	 * 
	 * @param type
	 *            目标显示方式
	 * @see #TARGETSHOWTYPE_NEW
	 * @see #TARGETSHOWTYPE_NEWTAB
	 * @see #TARGETSHOWTYPE_CURRENT
	 */
	public void setTargetShowType(Integer type) {
		this.properties.setTargetShowType(type);
	}

	/**
	 * 获取目标显示方式
	 * 
	 * @return 目标显示方式
	 * @see #TARGETSHOWTYPE_NEW
	 * @see #TARGETSHOWTYPE_NEWTAB
	 * @see #TARGETSHOWTYPE_CURRENT
	 */
	public Integer getTargetShowType() {
		return this.properties.getTargetShowType();
	}

	/**
	 * 设置是否需要认证标志
	 * @param needAuthenticate 是否需要认证标志
	 */
	public void setNeedAuthenticate(Boolean needAuthenticate) {
		this.properties.setNeedAuthenticate(needAuthenticate);
	}
	
	/**
	 * 获取是否需要认证标志
	 * @return 是否需要认证标志
	 */
	public Boolean isNeedAuthenticate() {
		return properties.isNeedAuthenticate();
	}
	

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.HYPERLINK;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaHyperLink newObject = (MetaHyperLink)super.clone();
		newObject.setProperties((MetaHyperLinkProperties)properties.clone());
		
		return newObject;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaHyperLink();
	}

	@Override
	public MetaHyperLinkProperties getProperties() {
		return properties;
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaHyperLinkProperties) properties;
	}
	
	/**
	 * 通过目标显示方式的字符串获取目标显示方式
	 * 
	 * @param type
	 *            字符串
	 * @return 显示方式
	 */
	public static int parseTargetShowType(String type) {
		int showType = -1;
		if (type.equalsIgnoreCase("New")) {
			showType = TARGETSHOWTYPE_NEW;
		} else if (type.equalsIgnoreCase("Current")) {
			showType = TARGETSHOWTYPE_CURRENT;
		} else if ( type.equalsIgnoreCase("NewTab") ) {
			showType = TARGETSHOWTYPE_NEWTAB;
		}
		return showType;
	}

	/**
	 * 获取目标显示方式的字符串
	 * @param type 目标的显示类型
	 * @return 目标显示方式的字符串
	 */
	public static String getTargetShowTypeStr(Integer type) {
		if(type == null)
			return "";
		
		switch (type) {
		case TARGETSHOWTYPE_NEW:
			return "New";
		case TARGETSHOWTYPE_NEWTAB:
			return "NewTab";
		case TARGETSHOWTYPE_CURRENT:
			return "Current";
		}
		return "";
	}
}
