package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboViewProperties;

/**
 * 按钮配置对象
 * 
 * @author my
 * @since YES1.0
 */
public class MetaComboView extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_COMBOVIEW;
	
	protected MetaComboViewProperties properties;

	public MetaComboView(){
		properties = newProperties();
	}

	/**
	 * 获取弹出视图根组件
	 * @return 弹出视图根组件
	 */
	public MetaComponent getRoot() {
		return getProperties().getRoot();
	}

	/**
	 * 设置弹出视图的根组件
	 * @param root 弹出视图根组件
	 */
	public void setRoot(MetaComponent root) {
		getProperties().setRoot(root);
	}
	
	/**
	 * 设置按钮图标
	 * @param icon 图标
	 */
	public void setIcon(String icon) {
		this.properties.setIcon(icon);
	}
	
	/**
	 * 取得按钮图标
	 * @return 图标
	 */
	public String getIcon() {
		return this.properties.getIcon();
	}
	
	/**
	 * 设置图标位置
	 * 
	 * @param iconLocation 图标位置
	 */
	public void setIconLocation(Integer iconLocation){
		this.properties.setIconLocation(iconLocation);
	}
	
	/**
	 * 获取图标位置
	 * 
	 * @return 图标位置
	 */
	public Integer getIconLocation(){
		return this.properties.getIconLocation();
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaComboViewProperties) properties;
	}
	
	@Override
	public MetaComboViewProperties getProperties() {
		return this.properties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.COMBOVIEW;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaComboView newObject = (MetaComboView)super.clone();
		newObject.setProperties((MetaComboViewProperties)properties.clone());
		return newObject;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject metaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		return metaObject;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaComboView();
	}
	
	public MetaComboViewProperties newProperties(){
		return new MetaComboViewProperties();
	}
}
