package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

/**
 * 颜色选择配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaColorPicker extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_COLORPICKER;

	/** 初始颜色 */
	private String initColor = "";

	/**
	 * 设置初始颜色
	 * 
	 * @param color
	 *            初始颜色
	 */
	public void setInitColor(String color) {
		this.initColor = color;
	}

	/**
	 * 获取初始颜色
	 * 
	 * @return 初始颜色
	 */
	public String getInitColor() {
		return this.initColor;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.COLORPICKER;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaColorPicker newObject = (MetaColorPicker)super.clone();
		newObject.setInitColor(initColor);
		
		return newObject;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaColorPicker();
	}

	@Override
	public AbstractMetaObject getProperties() {
		// TODO Auto-generated method stub
		return null;
	}
}
