package com.bokesoft.yigo.meta.form.component.bar;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaTreeMenuItem extends AbstractCompositeObject {
	/** 菜单项标识 */
	public static final int MenuItem = 0;
	/** 菜单项集合标识 */
	public static final int MenuItemCollection = 1;
	/** 菜单项的标识 */
	private String key = "";
	/** 菜单项的名称 */
	private String caption = "";
	/** 菜单项的图标 */
	private String icon = "";
	/** 菜单项的类型 */
	private Integer type = -1;
	/** 表单标识 */
	private String formKey = "";
	/** 脚本 */
	private MetaBaseScript action = null;
	/** 超链接地址 */
	private String url = "";
	/** 表单或超链接参数 */
	private String parameters = "";
	
	@Override
	public int getCompositeType() {
		return MenuItem;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}
	
	public void setKey(String key) {
		this.key = key;
	}
	
	public String getKey() {
		return this.key;
	}
	
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	public String getCaption() {
		return this.caption;
	}
	
	public void setIcon(String icon) {
		this.icon = icon;
	}
	
	public String getIcon() {
		return this.icon;
	}
	
	public void setType(Integer type) {
		this.type = type;
	}
	
	public Integer getType() {
		return this.type;
	}
	
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	public String getFormKey() {
		return this.formKey;
	}
	
	public void setAction(MetaBaseScript action) {
		this.action = action;
	}
	
	public MetaBaseScript getAction() {
		return this.action;
	}
	
	public void setURL(String url) {
		this.url = url;
	}
	
	public String getURL() {
		return this.url;
	}
	
	public void setParameters(String parameters) {
		this.parameters = parameters; 
	}
	
	public String getParameters() {
		return this.parameters;
	}

	public static final String TAG_NAME = "TreeMenuItem";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTreeMenuItem newObject = new MetaTreeMenuItem();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setIcon(icon);
		newObject.setType(type);
		newObject.setFormKey(formKey);
		newObject.setAction(action == null ? null : (MetaBaseScript)action.clone());
		newObject.setURL(url);
		newObject.setParameters(parameters);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTreeMenuItem();
	}

}
