package com.bokesoft.yigo.meta.form.component.bar;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

public class MetaToolBar extends MetaComponent {
	private MetaToolBarItemCollection itemCollection = null;
	private Boolean isDefault = true;
	public MetaToolBar() {
		super();
		itemCollection = new MetaToolBarItemCollection();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new AbstractMetaObject[] { itemCollection });
	}
	
	public static final String TAG_NAME = ControlType.STR_TOOLBAR;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public boolean needCheckExtend() {
		return false;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaToolBarItemCollection.TAG_NAME.equals(tagName) ) {
			itemCollection = new MetaToolBarItemCollection();
			resultMetaObject = itemCollection; 
		} else {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}

		return resultMetaObject;
	}

	@Override
	public int getControlType() {
		return ControlType.TOOLBAR;
	}

	public void setItemCollection(MetaToolBarItemCollection itemCollection) {
		this.itemCollection = itemCollection;
	}
	
	public MetaToolBarItemCollection getItemCollection() {
		return this.itemCollection;
	}
	
	public void setIsDefault(Boolean isDefault) {
		this.isDefault = isDefault;
	}
	
	public Boolean getIsDefault() {
		return this.isDefault;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaToolBar newObject = (MetaToolBar)super.clone();
		newObject.setItemCollection(itemCollection == null ? null : (MetaToolBarItemCollection)itemCollection.clone());
		newObject.setIsDefault(isDefault);

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaToolBar();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
}
