package com.bokesoft.yigo.meta.form.anim;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 动画属性集合配置对象
 * @author chenzs
 *
 */
public class MetaAnimPropertyCollection extends GenericKeyCollection<MetaAnimProperty>{
	
	public static final String TAG_NAME = "AnimPropertyCollection";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if(MetaAnimProperty.TAG_NAME.equals(tagName)){
			MetaAnimProperty property = new MetaAnimProperty();
			property.preProcessMetaObject(env, doc, node, flag, runType);
			add(property);
			child = property;
		}
		return child;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaAnimPropertyCollection();
	}
	 
}
