package com.bokesoft.yigo.meta.flatcanvas.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.w3c.dom.Element;

import com.bokesoft.yigo.meta.flatcanvas.common.AttributeItem;
import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;
import com.bokesoft.yigo.meta.flatcanvas.struct.FCAttrNames;

/**
 * 平面图配置对象
 * 
 * @author chenbinbin
 *
 */
public class MetaFCPaper extends AbstractMetaFCObject {
	
	public static final String TAG_NAME = "Paper";
	
	public static final List<String> ATTRS_PAPER = Arrays.asList(
			FCAttrNames.ATTR_key, FCAttrNames.ATTR_caption);
	
	private MetaFCBoard board = null;
	
	private MetaFCDataSource dataSource = null;
	
	public MetaFCPaper() {
		board = new MetaFCBoard();
		dataSource = new MetaFCDataSource();
		dataSource.setRefObjectKey("");
	}
	
	/**
	 * 获取平面图画板配置对象
	 * 
	 * @return 平面图画板配置对象
	 */
	public MetaFCBoard getMetaBoard() {
		return this.board;
	}
	
	/**
	 * 获取数据源
	 * 
	 * @return 数据源
	 */
	public MetaFCDataSource getDataSource() {
		return this.dataSource;
	}
	
	/**
	 * 获取面板宽度
	 * 
	 * @return 面板宽度
	 */
	public Integer getWidth() {
		return board.getWidth();
	}
	
	/**
	 * 设置面板宽度
	 * 
	 * @param width 面板宽度
	 */
	public void setWidth(int width) {
		board.setWidth(width);
	}
	
	/**
	 * 获取面板高度
	 * 
	 * @return 面板高度
	 */
	public Integer getHeight() {
		return board.getHeight();
	}
	
	/**
	 * 设置面板高度
	 * 
	 * @param height 面板高度
	 */
	public void setHeight(int height) {
		board.setHeight(height);
	}
	
	@Override
	public List<String> getPropItemKeys() {
		return ATTRS_PAPER;
	}
	
	@Override
	public List<AttributeItem> getPropItems() {
		List<AttributeItem> items = new ArrayList<AttributeItem>();
		List<AttributeItem> propItems = super.getPropItems();
		for (AttributeItem item: propItems) {
			items.add(item);
		}
		propItems = board.getPropItems();
		for (AttributeItem item: propItems) {
			items.add(item);
		}
		
		propItems = dataSource.getPropItems();
		for (AttributeItem item: propItems) {
			items.add(item);
		}
		
		return items;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	protected void loadChild(Element elem) {
		Element child = (Element) elem.getElementsByTagName(MetaFCBoard.TAG_NAME).item(0);
		board.loadFromElement(child);
		
		child = (Element) elem.getElementsByTagName(MetaFCDataSource.TAG_NAME).item(0);
		dataSource.loadFromElement(child);
	}

	@Override
	protected boolean isCollection() {
		return false;
	}

	@Override
	protected boolean saveChild(IContentHandler saveHandler, INode node) {
		boolean result = board.saveTo(saveHandler, node);
		result |= dataSource.saveTo(saveHandler, node);
		return result;
	}
}
