package com.bokesoft.yigo.meta.flatcanvas.node;

import java.util.Arrays;
import java.util.List;

import org.w3c.dom.Element;

import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;
import com.bokesoft.yigo.meta.flatcanvas.struct.FCAttrNames;

/**
 * 平面图关联的数据源
 * 
 * @author chenbinbin
 *
 */
public class MetaFCDataSource extends AbstractMetaFCObject {
	
	public static final String TAG_NAME = "DataSource";
	
	/** 关联的数据对象key */
	public static final List<String> ATTRS_DATASOURCE = Arrays.asList(
			FCAttrNames.ATTR_RefObjectKey);
	/**
	 * 设置平面图所关联的数据对象key
	 * 
	 * @param refkey 关联的数据对象key
	 */
	public void setRefObjectKey(String refkey) {
		set(FCAttrNames.ATTR_RefObjectKey, refkey);
	}
	
	/**
	 * 获取平面图所关联的数据对象key
	 * 
	 * @return 关联的数据对象key
	 */
	public String getRefObjectKey() {
		return get(FCAttrNames.ATTR_RefObjectKey);
	}

	@Override
	public List<String> getPropItemKeys() {
		return ATTRS_DATASOURCE;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	protected void loadChild(Element elem) {

	}

	@Override
	protected boolean isCollection() {
		return false;
	}

	@Override
	protected boolean saveChild(IContentHandler saveHandler, INode node) {
		return false;
	}
}
