package com.bokesoft.yigo.meta.flatcanvas.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 平面图中节点的的抽象集合类
 * 
 * @author chenbinbin
 *
 * @param <T> 子对象类参数
 */
public abstract class MetaFCCollection<T> extends AbstractMetaFCObject {
	/** 子对象集合 */
	protected List<T> collection = new ArrayList<T>();
	
	/**
	 * 添加子节点
	 * 
	 * @param child 子节点
	 */
	public void addItem(T child) {
		collection.add(child);
	}
	
	/**
	 * 移除子节点
	 * 
	 * @param t 子节点
	 */
	public void remove(T t) {
		collection.remove(t);
	}
	
	/**
	 * 集合值遍历
	 * 
	 * @return 子节点集合
	 */
	public Collection<T> values() {
		return collection;
	}
	
	/**
	 * 获取节点
	 * 
	 * @param index 序号
	 * @return 指定位置的节点
	 */
	public T get(int index) {
		return collection.get(index);
	}
	
	@Override
	protected boolean isCollection() {
		return true;
	}
	
	@Override
	public List<String> getPropItemKeys() {
		return null;
	}

}
