package com.bokesoft.yigo.meta.factory;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.List;

import com.bokesoft.yigo.meta.base.IConfigResolver;
import com.bokesoft.yigo.meta.base.IMetaResolver;

public class DefaultResourceResolver implements IMetaResolver {
	private IConfigResolver configResolver;
	private String parentPath = null;
	private String prefix = null;
	
	public DefaultResourceResolver(IConfigResolver configResolver, String parentPath, String prefix) {
		this.configResolver = configResolver;
		this.parentPath = parentPath;
		this.prefix = prefix;
	}

	@Override
	public boolean isListAbsolutePath() {
		return false;
	}

	@Override
	public InputStream read(String resource, int type) throws Exception {
		return configResolver.read(parentPath, prefix, resource, type);
	}
	
	@Override
	public URI getURI(String resource, int type) throws Exception {
		File f = new File(configResolver.getPath(parentPath, prefix, resource));
		if (f.isDirectory() || !f.exists()) {
			return null;
		}
		return f.toURI();
	}

	@Override
	public boolean write(String resource, byte[] data) throws Exception {
		return configResolver.write(parentPath, prefix, resource, data);
	}

	@Override
	public int listResource(String resource, String flag,
			List<String> resources, List<String> names, List<Boolean> flags) throws Exception {
		return configResolver.listResource(parentPath, prefix, resource, flag, resources, names, flags);
	}

	@Override
	public String getPath(String resource) {
		return configResolver.getPath(parentPath, prefix, resource);
	}

	@Override
	public char getSeparator() {
		return File.separatorChar;
	}
}
