package com.bokesoft.yigo.meta.enhance;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExtUIFunction extends GenericKeyCollection<MetaUIFunction> implements IElementMerge<MetaExtUIFunction> {

	public static final String TAG_NAME = "ExtUIFunction";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if(MetaUIFunction.TAG_NAME.equals(tagName)){
			MetaUIFunction uiFunc = new MetaUIFunction();
			uiFunc.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(uiFunc);
			resultMetaObject = uiFunc;
		} else {
			throw new MetaException(MetaException.NO_ACTION_DEFINED,
					"No MetaObject defined for " + tagName);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtUIFunction();
	}

	@Override
	public MetaExtUIFunction toMerge(MetaExtUIFunction obj) {
		if (obj != null) {
			Iterator<MetaUIFunction> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaUIFunction metaUIFunction = (MetaUIFunction) iterator.next();
				if (!containsKey(metaUIFunction.getKey())) {
					add(metaUIFunction);
				}	
			}
		}
		return this;
	}

}
