package com.bokesoft.yigo.meta.enhance;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExtReportFunction extends GenericKeyCollection<MetaFunction> implements IElementMerge<MetaExtReportFunction>{

public static final String TAG_NAME = "ExtReportFunction";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if(MetaFunction.TAG_NAME.equals(tagName)){
			MetaFunction func = new MetaFunction();
			func.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(func);
			resultMetaObject = func;
		} else {
			throw new MetaException(MetaException.NO_ACTION_DEFINED,
					"No MetaObject defined for " + tagName);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtReportFunction();
	}

	@Override
	public MetaExtReportFunction toMerge(MetaExtReportFunction obj) {
		if (obj != null) {
			Iterator<MetaFunction> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaFunction metaFunction = (MetaFunction) iterator.next();
				if (!containsKey(metaFunction.getKey())) {
					add(metaFunction);
				}
			}
		}
		return this;
	}

}
