package com.bokesoft.yigo.meta.diff.action;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.diff.MetaAdd;

public class MetaAddAction extends BaseDomAction<MetaAdd> {
	@Override
	public void load(Document document, Element element, MetaAdd meta,
			int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setContainerKey(DomHelper.readAttr(element, MetaConstants.DIFF_CONTAINER_KEY, ""));
		meta.setContainerTag(DomHelper.readAttr(element, MetaConstants.DIFF_CONTAINER_TAG, ""));
		meta.setPreviousKey(DomHelper.readAttr(element, MetaConstants.DIFF_PREVIOUS_KEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaAdd meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DIFF_CONTAINER_KEY, meta.getContainerKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DIFF_CONTAINER_TAG, meta.getContainerTag(), "");
		DomHelper.writeAttr(element, MetaConstants.DIFF_PREVIOUS_KEY, meta.getPreviousKey(), "");
	}
}

