package com.bokesoft.yigo.meta.diff;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaDelete extends KeyPairMetaObject {
	
	public static final String TAG_NAME = "Delete";
	
	// 节点标识
	private String key = null;
	// 被删除节点的tag
	private String deleteTag = "";
	// 被删除节点所在的父亲节点的tag
	private String parentTag = "";
	
	public MetaDelete() {
	}
	
	public MetaDelete(String key, String deleteTag, String parentTag) {
		this.key = key;
		this.deleteTag = deleteTag;
		this.parentTag = parentTag;
	}
	
	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return key;
	}


	public void setDeleteTag(String deleteTag) {
		this.deleteTag = deleteTag;
	}
	
	public String getDeleteTag() {
		return this.deleteTag;
	}
	
	public void setParentTag(String parentTag) {
		this.parentTag = parentTag;
	}
	
	public String getParentTag() {
		return this.parentTag;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDelete o = new MetaDelete();
		o.setKey(key);
		o.setDeleteTag(this.getDeleteTag());
		o.setParentTag(this.getParentTag());
		return o;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDelete();
	}
}
