package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaTableFilter extends AbstractMetaObject {
	/** 常量过滤条件 */
	public static final int Const = 0;
	/** 定制过滤条件 */
	public static final int Custom = 1;
	
	/** 过滤条件的类型 */
	private Integer type = Const;
	/** 过滤 */
	private String filter = "";
	/** 二开类*/
	private String impl = "";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "TableFilter";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}
	
	/**
	 * 设置过滤类型
	 * @param type 过滤类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}
	
	/**
	 * 取得过滤类型
	 * @return 过滤类型
	 */
	public Integer getType() {
		return this.type;
	}
	
	/**
	 * 设置过滤条件
	 * @param filter 过滤条件
	 */
	public void setFilter(String filter) {
		this.filter = filter;
	}
	
	/**
	 * 取得过滤条件
	 * @return 过滤条件
	 */
	public String getFilter() {
		return this.filter;
	}
	
	/**
	 * 设置二开实现类 继承ITableFilterBuilder
	 * @param impl 二开实现类
	 */
	public void setImpl(String impl){
		this.impl = impl;
	}
	
	/**
	 * 获取二开实现类
	 * @return 二开实现类
	 */
	public String getImpl(){
		return this.impl;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaTableFilter newObject = (MetaTableFilter)newInstance();
		newObject.setType(type);
		newObject.setFilter(filter);
		newObject.setImpl(impl);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTableFilter();
	}

}
