package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.intf.IMetaProject;

/**
 * MetaDataSource定义表单的数据源，其引用或内部包含一个数据对象。
 * @author wangyh
 *
 */
public class MetaDataSource extends AbstractMetaObject implements IPropertyMerger<MetaDataSource>{
	/** 引用的数据对象标识 */
	private String refObjectKey = "";
	/** 引用的主数据表标识 */
	private String refTableKey = "";

	/** 内置数据对象，通常是一个数据源对象对应一个数据对象 */
	private MetaDataObject dataObject = null;
	/** OID过滤条件 */
	private MetaOIDFilter OIDFilter = null;
	/** 载入前事件处理 */
	private MetaPreLoadProcess preLoadProcess = null;
	/** 载入后事件处理 */
	private MetaPostLoadProcess postLoadProcess = null;
	/** 保存前事件处理 */
	private MetaPreSaveProcess preSaveProcess = null;
	/** 保存后事件处理 */
	private MetaPostSaveProcess postSaveProcess = null;
	/** 删除前事件处理 */
	private MetaPreDeleteProcess preDeleteProcess = null;
	/** 删除后事件处理 */
	private MetaPostDeleteProcess postDeleteProcess = null;

	public MetaDataSource() {
		super();
	}

	/**
	 * 设置引用的数据对象标识
	 *
	 * @param refObjectKey 标识
	 */
	public void setRefObjectKey(String refObjectKey) {
		this.refObjectKey = refObjectKey;
	}

	/**
	 * 取得引用的数据对象标识
	 *
	 * @return 标识
	 */
	public String getRefObjectKey() {
		return this.refObjectKey;
	}

	/**
	 * 设置引用的数据表标识
	 * @param refTableKey 标识
	 */
	public void setRefTableKey(String refTableKey) {
		this.refTableKey = refTableKey;
	}

	/**
	 * 取得引用的数据表标识
	 * @return 标识
	 */
	public String getRefTableKey() {
		return this.refTableKey;
	}

	/**
	 * 设置OID过滤条件
	 * @param OIDFilter OID过滤条件
	 */
	public void setOIDFilter(MetaOIDFilter OIDFilter) {
		this.OIDFilter = OIDFilter;
	}

	/**
	 * 取得OID过滤条件
	 * @return OID过滤条件
	 */
	public MetaOIDFilter getOIDFilter() {
		return this.OIDFilter;
	}

	/**
	 * 设置载入前事件处理
	 *
	 * @param preLoadProcess
	 *            载入前事件处理
	 * @see MetaPreLoadProcess
	 */
	public void setPreLoadProcess(MetaPreLoadProcess preLoadProcess) {
		this.preLoadProcess = preLoadProcess;
	}

	/**
	 * 取得载入前事件处理
	 *
	 * @return 载入前事件处理
	 * @see MetaPreLoadProcess
	 */
	public MetaPreLoadProcess getPreLoadProcess() {
		return this.preLoadProcess;
	}

	/**
	 * 设置载入后事件处理
	 *
	 * @param postLoadProcess
	 *            载入后事件处理
	 * @see MetaPostLoadProcess
	 */
	public void setPostLoadProcess(MetaPostLoadProcess postLoadProcess) {
		this.postLoadProcess = postLoadProcess;
	}

	/**
	 * 取得载入后事件处理
	 *
	 * @return 载入后事件处理
	 * @see MetaPostLoadProcess
	 */
	public MetaPostLoadProcess getPostLoadProcess() {
		return this.postLoadProcess;
	}

	/**
	 * 设置保存前事件处理
	 *
	 * @param preSaveProcess
	 *            保存前事件处理
	 * @see MetaPreSaveProcess
	 */
	public void setPreSaveProcess(MetaPreSaveProcess preSaveProcess) {
		this.preSaveProcess = preSaveProcess;
	}

	/**
	 * 取得保存前事件处理
	 *
	 * @return 保存前事件处理
	 * @see MetaPreSaveProcess
	 */
	public MetaPreSaveProcess getPreSaveProcess() {
		return this.preSaveProcess;
	}

	/**
	 * 设置保存后事件处理
	 *
	 * @param postSaveProcess
	 *            保存后事件处理
	 * @see MetaPostSaveProcess
	 */
	public void setPostSaveProcess(MetaPostSaveProcess postSaveProcess) {
		this.postSaveProcess = postSaveProcess;
	}

	/**
	 * 取得保存后事件处理
	 *
	 * @return 保存后事件处理
	 * @see MetaPostSaveProcess
	 */
	public MetaPostSaveProcess getPostSaveProcess() {
		return this.postSaveProcess;
	}

	/**
	 * 取得删除前事件处理
	 * @return 删除前事件处理
	 */
	public MetaPreDeleteProcess getPreDeleteProcess() {
		return preDeleteProcess;
	}

	/**
	 * 设置删除前事件处理
	 * @param preDeleteProcess 删除前事件处理
	 */
	public void setPreDeleteProcess(MetaPreDeleteProcess preDeleteProcess) {
		this.preDeleteProcess = preDeleteProcess;
	}

	/**
	 * 取得删除后事件处理
	 * @return 删除后事件处理
	 */
	public MetaPostDeleteProcess getPostDeleteProcess() {
		return postDeleteProcess;
	}

	/**
	 * 设置删除后事件处理
	 * @param postDeleteProcess 删除后事件处理
	 */
	public void setPostDeleteProcess(MetaPostDeleteProcess postDeleteProcess) {
		this.postDeleteProcess = postDeleteProcess;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list,
				new AbstractMetaObject[] {
						dataObject,
						preLoadProcess,
						postLoadProcess,
						preSaveProcess,
						postSaveProcess,
						preDeleteProcess,
						postDeleteProcess,
						OIDFilter
				}
		);
	}

	public static final String TAG_NAME = "DataSource";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
													String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaDataObject.TAG_NAME)) {
			dataObject = new MetaDataObject();
			resultMetaObject = dataObject;
		} else if ( MetaOIDFilter.TAG_NAME.equals(tagName) ) {
			this.OIDFilter = new MetaOIDFilter();
			resultMetaObject = this.OIDFilter;
		} else if (MetaPreLoadProcess.TAG_NAME.equals(tagName)) {
			preLoadProcess = new MetaPreLoadProcess();
			resultMetaObject = preLoadProcess;
		} else if (MetaPostLoadProcess.TAG_NAME.equals(tagName)) {
			postLoadProcess = new MetaPostLoadProcess();
			resultMetaObject = postLoadProcess;
		} else if (MetaPreSaveProcess.TAG_NAME.equals(tagName)) {
			preSaveProcess = new MetaPreSaveProcess();
			resultMetaObject = preSaveProcess;
		} else if (MetaPostSaveProcess.TAG_NAME.equals(tagName)) {
			postSaveProcess = new MetaPostSaveProcess();
			resultMetaObject = postSaveProcess;
		} else if (MetaPreDeleteProcess.TAG_NAME.equals(tagName)) {
			this.preDeleteProcess = new MetaPreDeleteProcess();
			resultMetaObject = this.preDeleteProcess;
		} else if (MetaPostDeleteProcess.TAG_NAME.equals(tagName)) {
			this.postDeleteProcess = new MetaPostDeleteProcess();
			resultMetaObject = this.postDeleteProcess;
		}
		return resultMetaObject;
	}

	/**
	 * 取得数据对象元数据
	 * @return 数据对象元数据
	 */
	public MetaDataObject getDataObject() {
		return this.dataObject;
	}

	/**
	 * 设置数据对象元数据
	 * @param dataObject 数据对象元数据
	 */
	public void setDataObject(MetaDataObject dataObject) {
		this.dataObject = dataObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDataSource newObject = new MetaDataSource();
		newObject.setRefObjectKey(refObjectKey);
		newObject.setRefTableKey(refTableKey);
		newObject.setDataObject(dataObject == null ? null : (MetaDataObject)dataObject.clone());
		newObject.setOIDFilter(OIDFilter == null ? null : (MetaOIDFilter)OIDFilter.clone());
		newObject.setPreLoadProcess(preLoadProcess == null ? null : (MetaPreLoadProcess) preLoadProcess.clone());
		newObject.setPostLoadProcess(postLoadProcess == null ? null : (MetaPostLoadProcess) postLoadProcess.clone());
		newObject.setPreSaveProcess(preSaveProcess == null ? null : (MetaPreSaveProcess) preSaveProcess.clone());
		newObject.setPostSaveProcess(postSaveProcess == null ? null : (MetaPostSaveProcess) postSaveProcess.clone());
		newObject.setPreDeleteProcess(preDeleteProcess==null ? null : (MetaPreDeleteProcess) preDeleteProcess.clone());
		newObject.setPostDeleteProcess(postDeleteProcess==null ? null : (MetaPostDeleteProcess) postDeleteProcess.clone());

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDataSource();
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		if ( dataObject != null ) {
			dataObject.doPostProcess(flag, callback);
		}
	}

	public boolean isRefObject() {
		return refObjectKey != null && !refObjectKey.isEmpty();
	}

	public void merge4Diff(MetaDataSource dataSource) {
		MetaDataObject dataObject = dataSource.getDataObject();
		// 当前dataObject不为空时合并两个form的DataObject
		if (dataObject != null && this.dataObject != null) {
			String key = this.dataObject.getKey();
			if (key != null) {
				this.dataObject.merge(dataObject);
				//保持特殊马甲Project与源单Project一致
				this.dataObject.setProject(dataObject.getProject());
				this.dataObject.setKey(dataObject.getKey());
			}
		}
		doAfterMergeDataObject(dataSource);
	}

	@Override
	public void merge(MetaDataSource dataSource) {
		MetaDataObject dataObject = dataSource.getDataObject();

		// DataObject要么全部引用,保持key一致,要么自己定义
		// Key一致认为是引用,不一样认为是全部自己定义
		if( dataObject != null ) {
			String objectKey = dataObject.getKey();
			if( this.dataObject != null ) {
				IMetaProject project = this.dataObject.getProject();
				String key = this.dataObject.getKey();
				if( key != null && key.equals(objectKey) ) {
					this.dataObject = (MetaDataObject) dataObject.depthClone();
					this.dataObject.setProject(project);
				}
			}
		}

		doAfterMergeDataObject(dataSource);
	}

	private void doAfterMergeDataObject(MetaDataSource dataSource) {
		if( this.OIDFilter == null ) {
			MetaOIDFilter filter = dataSource.getOIDFilter();
			if( filter != null ) {
				this.OIDFilter = (MetaOIDFilter) filter.clone();
			}
		}
		if( this.preLoadProcess == null ) {
			MetaPreLoadProcess preload = dataSource.getPreLoadProcess();
			if( preload != null ) {
				this.preLoadProcess = (MetaPreLoadProcess) preload.clone();
			}
		}
		if( this.postLoadProcess == null ) {
			MetaPostLoadProcess postLoad = dataSource.getPostLoadProcess();
			if( postLoad != null ) {
				this.postLoadProcess = (MetaPostLoadProcess) postLoad.clone();
			}
		}
		if( this.preSaveProcess == null ) {
			MetaPreSaveProcess preSave = dataSource.getPreSaveProcess();
			if( preSave != null ) {
				this.preSaveProcess = (MetaPreSaveProcess) preSave.clone();
			}
		}
		if( this.postSaveProcess == null ) {
			MetaPostSaveProcess postSave = dataSource.getPostSaveProcess();
			if( postSave != null ) {
				this.postSaveProcess = (MetaPostSaveProcess) postSave.clone();
			}
		}
		if( this.preDeleteProcess == null ) {
			MetaPreDeleteProcess preDelete = dataSource.getPreDeleteProcess();
			if( preDelete != null ) {
				this.preDeleteProcess = (MetaPreDeleteProcess) preDelete.clone();
			}
		}
		if( this.postDeleteProcess == null ) {
			MetaPostDeleteProcess postDelete = dataSource.getPostDeleteProcess();
			if( postDelete != null ) {
				this.postDeleteProcess = (MetaPostDeleteProcess) postDelete.clone();
			}
		}
	}
}
