package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ColumnRightsType;
import com.bokesoft.yigo.common.def.DataGroupGranularity;
import com.bokesoft.yigo.common.def.DataSplitType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.SortType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.annotation.DataElementAttribute;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.util.MetaAnnotationUtil;

/**
 * 数据列配置对象
 *
 * @author 李姝
 * @since YES1.0
 */
public class MetaColumn extends KeyPairMetaObject {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/** 列标志，表范围内唯一 */
	private String key = "";
	/** 列名称 */
	private String caption = "";
	/** 列的默认值 */
	private String defaultValue = null;
	/** 列的默认计算值 (暂时未实现) */
	private String defaultFormulaValue = "";
	/** 列的描述 */
	private String description = "";
	/** 是否持久化 */
	private Boolean persist = true;
	/** 是否在保存时忽略此列 */
	private Boolean ignoreSave = false;
	/** 是否在 查询时忽略此列 */
	private Boolean ignoreQuery = false;
	/** 是否在 修改时忽略此列 */
	private Boolean ignoreModify = false;
	/** 列存储数据所用的数据表的列名 */
	private String dbColumnName = "";
	/** 列的数据类型 */
	@DataElementAttribute()
	private Integer dataType = -1;
	/** 字符长度或二进制大小 */
	@DataElementAttribute()
	private Integer length = 0;
	/** 数值精度 */
	@DataElementAttribute()
	private Integer precision = 0;
	/** 小数位数 */
	@DataElementAttribute()
	private Integer scale = 0;
	/** 本地时区标志 */
	private Boolean localTimeZone = false;
	/** 是否业务关键字 */
	private Boolean isPrimary = false;
	/** 是否缓存，只在字典中有效，用于建立字典缓存中的数据列集合 */
	private Boolean cache = false;
	/** 是否需要处理权限 */
	private Integer needRights = ColumnRightsType.DEFAULT;
	/** 需要过滤权限的字典的标识 */
	private String itemKey = "";
	/** 是否扩展列 */
	private Boolean isExpand = false;
	/** 扩展源 */
	private MetaBaseScript expandSource = null;
	/** 隐藏属性，如果为true，表示从数据对象中隐去该列 */
	private Boolean hidden = false;
	/** 分组的类型 */
	private Integer groupType = DataGroupGranularity.None;
	/** 期间粒度(用于带有期间功能的迁移表) */
	private Integer periodGranularity = -1;
	/** 字段拆分类型，取值为Period(期间) */
	private Integer splitType = DataSplitType.None;
	/** 期间特殊值回调函数*/
	private String periodImpl = "";
	/** 系统自动生成标识 */
	private Boolean autoGen = false;
	/** 访问控制标志 */
	private Boolean accessControl = false;
	/** 是否为不开放修改的系统控制字段 */
	private Boolean systemControlField = false;
	/** 排序类型 */
	private Integer sort = SortType.None;
	/** 是否为主键字段 */
	private Boolean isPrimaryKey = false;
	/** 所在表的引用 */
	private MetaTable table = null;
	/** 用户标志 */
	private String userTag = "";
	/** 支持多语种*/
	private Boolean supportI18n = false;
	/** 字典数据列绑定的code列*/
	private String codeColumnKey = "";
	/** 数据元素标识 */
	private String dataElementKey = null;
	/** 数据元素对象 */
	private MetaDataElement dataElement = null;
	/** 关联列 */
	private String refCol = null;
	/** 动态字典itemkey存储列*/
	private String refItemKeyCol = null;
	
	public MetaColumn() {
		super();
	}

	public void setTable(MetaTable table) {
		this.table = table;
	}

	public MetaTable getTable() {
		return table;
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { expandSource });
	}

	/**
	 * 列的标签名
	 */
	public static final String TAG_NAME = "Column";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaConstants.COLUMN_EXPAND_SOURCE.equals(tagName)) {
			expandSource = new MetaBaseScript(MetaConstants.COLUMN_EXPAND_SOURCE);
			resultMetaObject = expandSource;
		}
		return resultMetaObject;
	}

	/**
	 * 获取列的名称
	 *
	 * @return 列名称
	 */
	public String getCaption() {
		return caption;
	}

	/**
	 * 获取列的默认值
	 *
	 * @return 列的默认值
	 */
	public String getDefaultValue() {
		return defaultValue;
	}

	/**
	 * 获取列的描述
	 *
	 * @return 列描述
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * 获取列是否持久化的判断值
	 *
	 * @return true或者false
	 */
	public Boolean isPersist() {
		return persist;
	}

	/**
	 * 获取列存储数据所用的数据表的列名
	 *
	 * @return 列存储数据所用的数据表的列名
	 */
	public String getDBColumnName() {
		return dbColumnName;
	}

	/**
	 * 取得绑定的数据表的列名
	 *
	 * @return 返回绑定的数据表的列名，如果DBColumnName不为空，那么回返DBCo lumnName，否则返回Key
	 */
	public String getBindingDBColumnName() {
		return (dbColumnName != null && !dbColumnName.isEmpty()) ? dbColumnName : key;
	}

	/**
	 * 获取列的数据类型
	 *
	 * @return 列的数据类型
	 */
	public Integer getDataType() {
		return dataType;
	}

	/**
	 * 设置列的标志
	 *
	 * @param key
	 *            标志
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 设置列的名称
	 *
	 * @param caption
	 *            名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 设置列的默认值
	 *
	 * @param defaultValue
	 *            默认值
	 */
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	/**
	 * 设置列描述
	 *
	 * @param description
	 *            描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * 设置列是否持久化
	 *
	 * @param persist
	 *            持久化标志
	 */
	public void setPersist(Boolean persist) {
		this.persist = persist;
	}

	/**
	 * 设置列存储数据所用的数据表的列名
	 *
	 * @param dbColumnName
	 *            列名
	 */
	public void setDBColumnName(String dbColumnName) {
		this.dbColumnName = dbColumnName;
	}

	/**
	 * 设置列的数据类型
	 *
	 * @param dataType
	 *            数据类型
	 */
	public void setDataType(Integer dataType) {
		this.dataType = dataType;
	}

	/**
	 * 获得字符长度或二进制大小
	 *
	 * @return 字符长度或二进制大小
	 */
	public Integer getLength() {
		return length;
	}

	/**
	 * 设置 字符长度或二进制大小
	 *
	 * @param length
	 *            字符长度或二进制大小
	 */
	public void setLength(Integer length) {
		if (null!=length && length == 1) {
			length = StringUtil.OneBlank_STRING_Length;
		}
		this.length = length;
	}

	/**
	 * 获取数值精度
	 *
	 * @return 数值精度
	 */
	public Integer getPrecision() {
		return precision;
	}

	/**
	 * 设置数值精度
	 *
	 * @param precision
	 *            数值精度
	 */
	public void setPrecision(Integer precision) {
		this.precision = precision;
	}

	/**
	 * 获取小数位数
	 *
	 * @return 小数位数
	 */
	public Integer getScale() {
		return scale;
	}

	/**
	 * 设置小数位数
	 *
	 * @param scale
	 *            小数位数
	 */
	public void setScale(Integer scale) {
		this.scale = scale;
	}

	/**
	 * 设置本地时区标志
	 *
	 * @param localTimeZone
	 *            本地时区标志
	 */
	public void setLocalTimeZone(Boolean localTimeZone) {
		this.localTimeZone = localTimeZone;
	}

	/**
	 * 取得本地时区标志
	 *
	 * @return 本地时区标志
	 */
	public Boolean isLocalTimeZone() {
		return this.localTimeZone;
	}

	/**
	 * 设置是否业务关键字
	 *
	 * @param isPrimary
	 *            是否业务关键字
	 */
	public void setIsPrimary(Boolean isPrimary) {
		this.isPrimary = isPrimary;
	}

	/**
	 * 取得是否业务关键字
	 *
	 * @return 是否业务关键字
	 */
	public Boolean getIsPrimary() {
		return this.isPrimary;
	}

	/**
	 * 设置是否缓存字段
	 *
	 * @param cache
	 *            是否缓冲字段标记
	 * @see #cache
	 */
	public void setCache(Boolean cache) {
		this.cache = cache;
	}

	/**
	 * 取得是否缓存字段标记
	 *
	 * @return 缓存字段标记
	 * @see #cache
	 */
	public Boolean getCache() {
		return this.cache;
	}

	/**
	 * 设置默认计算值
	 *
	 * @param defaultFormulaValue
	 *            默认计算值
	 */
	public void setDefaultFormulaValue(String defaultFormulaValue) {
		this.defaultFormulaValue = defaultFormulaValue;
	}

	/**
	 * 取得默认计算值
	 *
	 * @return 默认计算值
	 */
	public String getDefaultFormulaValue() {
		return this.defaultFormulaValue;
	}

	/**
	 * 设置是否需要处理权限标志
	 *
	 * @param needRights
	 *            是否需要处理权限标志
	 */
	public void setNeedRights(Integer needRights) {
		this.needRights = needRights;
	}

	/**
	 * 取得是否需要处理权限标志
	 *
	 * @return 是否需要处理权限标志
	 */
	public Integer getNeedRights() {
		return this.needRights;
	}

	/**
	 * 设置需要过滤权限的字典的标识
	 *
	 * @param itemKey
	 *            字典标识
	 */
	public void setItemKey(String itemKey) {
		this.itemKey = itemKey;
	}

	/**
	 * 取得需要过滤权限的字典的标识
	 *
	 * @return 字典标识
	 */
	public String getItemKey() {
		return this.itemKey;
	}

	/**
	 * 设置是否扩展列
	 *
	 * @param isExpand
	 *            扩展列标志
	 */
	public void setExpand(Boolean isExpand) {
		this.isExpand = isExpand;
	}

	/**
	 * 取得是否扩展列
	 *
	 * @return 扩展列标志
	 */
	public Boolean isExpand() {
		return this.isExpand;
	}

	/**
	 * 设置扩展源
	 *
	 * @param expandSource
	 *            扩展源
	 */
	public void setExpandSource(MetaBaseScript expandSource) {
		this.expandSource = expandSource;
	}

	/**
	 * 取得扩展源
	 *
	 * @return 扩展源
	 */
	public MetaBaseScript getExpandSource() {
		return this.expandSource;
	}

	/**
	 * 设置隐藏属性
	 *
	 * @param hidden
	 *            隐藏标志
	 */
	public void setHidden(Boolean hidden) {
		this.hidden = hidden;
	}

	/**
	 * 取得隐藏属性
	 *
	 * @return 隐藏标志
	 */
	public Boolean isHidden() {
		return this.hidden;
	}

	/**
	 * 取得是否分组字段
	 *
	 * @return 是否分组字段
	 */
	public boolean isGroup() {
		return groupType != DataGroupGranularity.None;
	}

	/**
	 * 是否是数值类型
	 * @return 如果是数据类型返回true，否则返回false
	 */
	public boolean isNumeric() {
		return dataType == DataType.INT ||
				dataType == DataType.LONG ||
				dataType == DataType.DOUBLE ||
				dataType == DataType.NUMERIC ||
				dataType == DataType.FLOAT;
	}
	
	/**
	 * 是否是字符串类型
	 * @return 如果是数据类型返回true，否则返回false
	 */
	public boolean isString() {
		return dataType == DataType.STRING || 
			   dataType == DataType.TEXT || 
			   dataType == DataType.FIXED_STRING;
	}

	/**
	 * 取得分组字段类型属性
	 *
	 * @return 分组字段类型那个标志
	 */
	public Integer getGroupType() {
		return groupType;
	}

	/**
	 * 设置分组字段类型属性
	 *
	 * @param groupType
	 *            分组字段类型标志
	 */
	public void setGroupType(Integer groupType) {
		this.groupType = groupType;
	}

	/**
	 * 取得字段拆分类型属性
	 *
	 * @return 字段拆分类型那个标志
	 */
	public Integer getSplitType() {
		return splitType;
	}

	/**
	 * 设置字段拆分类型属性
	 *
	 * @param splitType
	 *            字段拆分类型标志
	 */
	public void setSplitType(Integer splitType) {
		this.splitType = splitType;
	}

	/**
	 * 系统生成标志
	 *
	 * @param autoGen
	 *            标志
	 */
	public void setAutoGen(Boolean autoGen) {
		this.autoGen = autoGen;
	}

	@Override
	public boolean isAutoGen() {
		return this.autoGen;
	}

	/**
	 * 设置访问控制标志
	 *
	 * @param accessControl
	 *            标志
	 */
	public void setAccessControl(Boolean accessControl) {
		this.accessControl = accessControl;
	}

	/**
	 * 取得访问控制标志
	 *
	 * @return 标志
	 */
	public Boolean isAccessControl() {
		return this.accessControl;
	}

	/**
	 * 是否系统控制字段标志
	 *
	 * @return 标志
	 */
	public Boolean isSystemControlField() {
		return systemControlField;
	}

	/**
	 * 设置系统控制字段标志
	 *
	 * @param systemControlField
	 *            标志
	 */
	public void setSystemControlField(Boolean systemControlField) {
		this.systemControlField = systemControlField;
	}

	/**
	 * 设置排序类型
	 *
	 * @param sort
	 *            排序类型
	 */
	public void setSort(Integer sort) {
		this.sort = sort;
	}

	/**
	 * 取得排序类型
	 *
	 * @return 取得排序类型
	 */
	public Integer getSort() {
		return this.sort;
	}

	/**
	 * 既得是否忽略保存标志
	 *
	 * @return 标志
	 */
	public Boolean isIgnoreSave() {
		return ignoreSave;
	}

	/**
	 * 设置是否角力保存标志
	 *
	 * @param ignoreSave
	 *            标志
	 */
	public void setIgnoreSave(Boolean ignoreSave) {
		this.ignoreSave = ignoreSave;
	}

	public Boolean isIgnoreQuery() {
		return ignoreQuery;
	}

	public void setIgnoreQuery(Boolean ignoreQuery) {
		this.ignoreQuery = ignoreQuery;
	}

	/**
	 * 是否忽略更新
	 * @return 是否忽略更新
	 */
	public Boolean isIgnoreModify() {
		return this.ignoreModify;
	}
	
	/**
	 * 设置是否忽略更新
	 * @param ignore 忽略更新
	 */
	public void ignoreModify(Boolean ignore) {
		this.ignoreModify = ignore;
	}
	
	/**
	 * 设置期间粒度
	 *
	 * @param periodGranularity
	 *            期间粒度
	 */
	public void setPeriodGranularity(Integer periodGranularity) {
		this.periodGranularity = periodGranularity;
	}

	/**
	 * 取得期间粒度
	 *
	 * @return 期间粒度
	 */
	public Integer getPeriodGranularity() {
		return this.periodGranularity;
	}

	/**
	 * 取得是否为主键
	 *
	 * @return 是否为主键
	 */
	public Boolean isPrimaryKey() {
		return isPrimaryKey;
	}

	/**
	 * 设置是否为主键
	 *
	 * @param isPrimaryKey
	 *            是否为主键
	 */
	public void setPrimaryKey(Boolean isPrimaryKey) {
		this.isPrimaryKey = isPrimaryKey;
	}

	/**
	 * 取得期间实现类
	 * @return 实现类名称
	 */
	public String getPeriodImpl() {
		return periodImpl;
	}

	/**
	 * 设置期间实现类名称
	 * @param periodImpl 实现类名称
	 */
	public void setPeriodImpl(String periodImpl) {
		this.periodImpl = periodImpl;
	}

	/**
	 * 设置用户标志
	 * @param userTag 用户标志
	 */
	public void setUserTag(String userTag) {
		this.userTag = userTag;
	}

	/**
	 * 取得用户标志
	 * @return 用户标志
	 */
	public String getUserTag() {
		return this.userTag;
	}

	/**
	 * 获取字典绑定的Code列
	 * @return
	 */
	public String getCodeColumnKey() {
		return codeColumnKey;
	}

	/**
	 * 设置字典绑定的Code列
	 * @param codeColumnKey
	 */
	public void setCodeColumnKey(String codeColumnKey) {
		this.codeColumnKey = codeColumnKey;
	}

	/**
	 * 获取数据元素标识
	 * @return 数据元素标识
	 */
	public String getDataElementKey() {
		return this.dataElementKey;
	}
	
	/**
	 * 设置数据元素标识
	 * @param dataElementKey 数据元素标识
	 */
	public void setDataElementKey(String dataElementKey) {
		this.dataElementKey = dataElementKey;
	}
	
	/**
	 * 设置数据元素
	 * @param dataElement 数据元素
	 */
	public void setDataElement(MetaDataElement dataElement) {
		this.dataElement = dataElement;
	}
	
	/**
	 * 获取数据元素
	 * @return 数据元素
	 */
	public MetaDataElement getDataElement() {
		return this.dataElement;
	}
	
	/**
	 * 设置关联列
	 * @param refCol 关联列
	 */
	public void setRefCol(String refCol) {
		this.refCol = refCol;
	}
	
	/**
	 * 获取关联列
	 * @return 关联列
	 */
	public String getRefCol() {
		return this.refCol;
	}
	
	/**
	 * 设置动态字典itemKey列
	 * @param itemKeyCol 动态字典itemKey列
	 */
	public void setRefItemKeyCol(String itemKeyCol) {
		this.refItemKeyCol = itemKeyCol;
	}
	
	/**
	 * 获取动态字典itemKey列
	 * @return 动态字典itemKey列
	 */
	public String getRefItemKeyCol() {
		return this.refItemKeyCol;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaColumn newObject = new MetaColumn();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setDefaultValue(defaultValue);
		newObject.setDefaultFormulaValue(defaultFormulaValue);
		newObject.setDescription(description);
		newObject.setPersist(persist);
		newObject.setDBColumnName(dbColumnName);
		newObject.setDataType(dataType);
		newObject.setLength(length);
		newObject.setPrecision(precision);
		newObject.setScale(scale);
		newObject.setIsPrimary(isPrimary);
		newObject.setCache(cache);
		newObject.setNeedRights(needRights);
		newObject.setItemKey(itemKey);
		newObject.setExpand(isExpand);
		newObject.setExpandSource(expandSource == null ? null : (MetaBaseScript) expandSource.clone());
		newObject.setHidden(hidden);
		newObject.setGroupType(groupType);
		newObject.setSplitType(splitType);
		newObject.setAutoGen(autoGen);
		newObject.setAccessControl(accessControl);
		newObject.setSort(sort);
		newObject.setIgnoreSave(ignoreSave);
		newObject.setIgnoreQuery(ignoreQuery);
		newObject.ignoreModify(ignoreModify);
		newObject.setPeriodGranularity(periodGranularity);
		newObject.setUserTag(userTag);
		newObject.setCodeColumnKey(codeColumnKey);
		newObject.setSupportI18n(supportI18n);
		newObject.setDataElementKey(dataElementKey);
		newObject.setDataElement(dataElement);
		newObject.setRefCol(refCol);
		newObject.setRefItemKeyCol(refItemKeyCol);
		newObject.setPrimaryKey(isPrimaryKey);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaColumn();
	}

	/**
	 * 设置支持多语种
	 * @param i18n 标志
	 */
	public void setSupportI18n(Boolean i18n) {
		this.supportI18n = i18n;
	}

	/**
	 * 是否支持多语种
	 * @return 标志
	 */
	public Boolean isSupportI18n(){
		return supportI18n;
	}
	
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		if(dataElementKey == null || dataElementKey.isEmpty()) {
			return;
		}
		try {
			// 有dataElement 的情况下， 不做doPostProcess 这种情况出现在外挂数据源 处理一次，表单又处理一次
			if(dataElement != null) {
				return;
			}
			if(callback != null) {
				try {
					callback.call(this);
				} catch (Throwable e) {
					throw new RuntimeException(e);
				}
			}
			if(dataElement != null) {
				checkValid();
				MetaAnnotationUtil.mergeProperty(this, dataElement);
			}
		}catch(Throwable e) {
			throw new MetaException(MetaException.META_LOAD_ERROR, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.MetaLoadError), MetaColumn.TAG_NAME, this.key), e);             
		}
	}
	
	private void checkValid() {
		if(dataElementKey == null || dataElementKey.isEmpty()) {
			return;
		}
		if(dataType!= null && dataType > 0) {
    		throw new MetaException(MetaException.ATTRIBUTE_CONFLICT, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.AttributeConflict), MetaConstants.COLUMN_DATAELEMENTKEY, MetaConstants.COLUMN_DATATYPE));             

		}
		
		if(length != null && length > 0) {
    		throw new MetaException(MetaException.ATTRIBUTE_CONFLICT, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.AttributeConflict), MetaConstants.COLUMN_DATAELEMENTKEY, MetaConstants.COLUMN_DEF_LENGTH));             

		}
		
		if(precision != null && precision > 0) {
    		throw new MetaException(MetaException.ATTRIBUTE_CONFLICT, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.AttributeConflict), MetaConstants.COLUMN_DATAELEMENTKEY, MetaConstants.COLUMN_DEF_PRECISION));             

		}
		
		if(scale != null && scale > 0) {
    		throw new MetaException(MetaException.ATTRIBUTE_CONFLICT, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.AttributeConflict), MetaConstants.COLUMN_DATAELEMENTKEY, MetaConstants.COLUMN_DEF_SCALE));             

		}
	}

	/**
	 * 字段是否区分大小写
	 * @return
	 */
	public boolean isCaseSensitive() {
		MetaDataElement dataElement = this.getDataElement();
		MetaDomain domain = dataElement == null ? null : dataElement.getDomain();
		return domain != null && Boolean.TRUE.equals(domain.isCaseSensitive());
	}
}
