package com.bokesoft.yigo.meta.datamigration;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.*;

/**
 * MetaDMTargetTable类定义一张迁移目标表中的字段域集合。 需要定义表的标识和字段的集合。
 * 每个表至少包含一个或一个以下的字段定义，字段的定义见{@link MetaDMTargetField}。
 * @author 王元和
 * @since YES 1.0
 * @see MetaDMTargetField
 */
public class MetaDMTargetTable extends GenericKeyCollectionWithKey<MetaDMTargetField> {
	/** 目标表标识 */
	private String tableKey = null;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "TargetTable";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaDMTargetField.TAG_NAME.equals(tagName) ) {
			MetaDMTargetField metaDMTargetField = new MetaDMTargetField();
			metaDMTargetField.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaDMTargetField);
			resultMetaObject = metaDMTargetField;
		}
		return resultMetaObject;
	}

	/**
	 * 设置表标识
	 * @param tableKey 表标识
	 * @see #tableKey
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
	/**
	 * 取得表标识
	 * @return 表标识
	 * @see #tableKey
	 */
	public String getTableKey() {
		return this.tableKey;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaDMTargetTable();
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaDMTargetTable newTargetTable = (MetaDMTargetTable) super.clone();
		newTargetTable.setTableKey(tableKey);
		return newTargetTable;
	}

	@Override
	public String getKey() {
		return getTableKey();
	}
}
