package com.bokesoft.yigo.meta.datamigration;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.*;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

/**
 * MetaDMSourceTable类定义一张迁移源表中字段域集合。 需要定义表的标识和字段的集合。
 * 每个表至少包含一个或一个以下的字段定义，字段的定义见{@link MetaDMSourceField}。
 * @author 王元和
 * @since YES 1.0
 * @see MetaDMSourceField
 */
public class MetaDMSourceTable extends GenericKeyCollectionWithKey<MetaDMSourceField> implements Cloneable, IPropertyMerger<MetaDMSourceTable> {
	/** 源表标识 */
	private String tableKey = null;
	/** 源表标识 */
	private String key = null;
	/** 是否主表 */
	private Boolean isPrimary = false;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "SourceTable";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaDMSourceField.TAG_NAME.equals(tagName) ) {
			resultMetaObject = new MetaDMSourceField();
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
			add((MetaDMSourceField) resultMetaObject);
		}
		return resultMetaObject;
	}

	/**
	 * 设置表标识
	 * @param tableKey 表标识
	 * @see #tableKey
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
	/**
	 * 取得表标识
	 * @return 表标识
	 * @see #tableKey
	 */
	public String getTableKey() {
		return (tableKey != null && !tableKey.isEmpty()) ? tableKey : key;
	}
	public String getSourceTableKey() {
		return tableKey;
	}
	@Override
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 设置主表标志
	 * @param isPrimary 主表标志
	 * @see #isPrimary
	 */
	public void setIsPrimary(Boolean isPrimary) {
		this.isPrimary = isPrimary;
	}
	
	/**
	 * 取得主表标志
	 * @return 主表标志
	 * @see #isPrimary
	 */
	public Boolean getIsPrimary() {
		return this.isPrimary;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaDMSourceTable();
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaDMSourceTable newSourceTable = (MetaDMSourceTable) super.clone();
		newSourceTable.setTableKey(tableKey);
		newSourceTable.setKey(key);
		newSourceTable.setIsPrimary(isPrimary);
		return newSourceTable;
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void merge(MetaDMSourceTable metaDMSourceTable) {

	}
}
