package com.bokesoft.yigo.meta.datamap.target;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 数据映射目标表
 * 
 * @author 刘翔翔
 *
 */
public class MetaTargetTable extends GenericNoKeyCollectionWithKey<MetaTargetField> {

	/** 标签名 */
	public static final String TAG_NAME = "TargetTable";
	/** 目标表的标识 */
	private String key = "";
	/** 是否为主表 */
	private Boolean isPrimary = false;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		if (MetaTargetField.TAG_NAME.equals(tagName)) {
			MetaTargetField field = new MetaTargetField();
			field.preProcessMetaObject(env, doc, node, flag, runType);
			add(field);

			return field;
		}
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTargetTable();
	}

	@Override
	public String getKey() {
		return key;
	}

	public Boolean isPrimary() {
		return isPrimary;
	}

	public void setPrimary(Boolean isPrimary) {
		this.isPrimary = isPrimary;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaTargetTable newTargetTable = (MetaTargetTable) super.clone();
		newTargetTable.setKey(key);
		newTargetTable.setPrimary(isPrimary);
		return newTargetTable;
	}
}
