package com.bokesoft.yigo.meta.dataelement;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.annotation.DomainAttribute;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaFieldLabelCollection;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.util.MetaAnnotationUtil;

public class MetaDataElement extends KeyPairMetaObject{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/** 配置文件中对应片段的起始标签名称 */
	public static final String TAG_NAME = "DataElement";
	
	/** 标识 */
	private String key = null;
	/** 域标识*/
	private String domainKey = null;
	/** 名称 */
	private String caption = null;
	/** 列的数据类型 */
	@DomainAttribute()
	private Integer dataType = null;
	/** 字符长度或二进制大小 */
	@DomainAttribute()
	private Integer length = null;
	/** 数值精度 */
	@DomainAttribute()
	private Integer precision = null;
	/** 小数位数 */
	@DomainAttribute()
	private Integer scale = null;
	/** 参数ID */
	private String paramID = null;
	/** 缺省组件名称 */
	private String defaultCaption = null;
	/** 更改文档 */
	private Boolean dataDiffLog = null;
	/** 无输入历史记录 */
	private Boolean noHistory = null;
	/** 字段标签 */
	private MetaFieldLabelCollection fieldLabelCollection = null;
	/** 域对象 */
	private MetaDomain domain = null;
	
	/** 映射所在的工程*/
	private IMetaProject project = null;
	
	/** 系统自动生成标识 */
	private boolean autoGen = false;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public String getKey() {
		return this.key;
	}
	
	@Override
	public void setKey(String key){
		this.key = key;
	}
	
	public String getDomainKey() {
		return this.domainKey;
	}
	
	public void setDomainKey(String domainKey) {
		this.domainKey = domainKey;
	}
	
	public String getCaption() {
		return this.caption;
	}
	
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 获取列的数据类型
	 *
	 * @return 列的数据类型
	 */
	public Integer getDataType() {
		return dataType;
	}
	
	/**
	 * 设置列的数据类型
	 *
	 * @param dataType
	 *            数据类型
	 */
	public void setDataType(Integer dataType) {
		this.dataType = dataType;
	}
	
	/**
	 * 获得字符长度或二进制大小
	 *
	 * @return 字符长度或二进制大小
	 */
	public Integer getLength() {
		return length;
	}

	/**
	 * 设置 字符长度或二进制大小
	 *
	 * @param length
	 *            字符长度或二进制大小
	 */
	public void setLength(Integer length) {
		this.length = length;
	}

	/**
	 * 获取数值精度
	 *
	 * @return 数值精度
	 */
	public Integer getPrecision() {
		return precision;
	}

	/**
	 * 设置数值精度
	 *
	 * @param precision
	 *            数值精度
	 */
	public void setPrecision(Integer precision) {
		this.precision = precision;
	}
	
	/**
	 * 获取小数位数
	 *
	 * @return 小数位数
	 */
	public Integer getScale() {
		return scale;
	}

	/**
	 * 设置小数位数
	 *
	 * @param scale
	 *            小数位数
	 */
	public void setScale(Integer scale) {
		this.scale = scale;
	}
	
	/**
	 * 设置参数ID 
	 * @param paramID 参数ID 
	 */
	public void setParamID(String paramID) {
		this.paramID = paramID;
	}
	
	/**
	 * 获取参数ID 
	 */
	public String getParamID() {
		return this.paramID;
	}
	
	/**
	 * 设置缺省组件名称
	 * @param defaultCaption 缺省组件名称
	 */
	public void setDefaultCaption(String defaultCaption) {
		this.defaultCaption = defaultCaption;
	}
	
	/**
	 * 获取缺省组件名称
	 * @return 缺省组件名称
	 */
	public String getDefaultCaption(){
		return this.defaultCaption;
	}
	
	/**
	 * 设置更改文档
	 * @param dataDiffLog 更改文档
	 */
	public void setDataDiffLog(Boolean dataDiffLog) {
		this.dataDiffLog = dataDiffLog;
	}
	
	/**
	 * 获取更改文档
	 * @return 更改文档
	 */
	public Boolean getDataDiffLog() {
		return this.dataDiffLog;	
	}
	
	/**
	 * 设置无输入历史记录
	 * @param noHistory 无输入历史记录
	 */
	public void setNoHistory(Boolean noHistory) {
		this.noHistory = noHistory;
	}
	
	/**
	 * 获取无输入历史记录
	 * @return 无输入历史记录
	 */
	public Boolean getNoHistory() {
		return this.noHistory;
	}
	
	/**
	 * 设置字段标签集合
	 * @param fieldLabelCollection 字段标签集合
	 */
	public void setFieldLabelCollection(MetaFieldLabelCollection fieldLabelCollection) {
		this.fieldLabelCollection = fieldLabelCollection;
	}
	
	/**
	 * 获取字段标签集合
	 * @return 字段标签集合
	 */
	public MetaFieldLabelCollection getFieldLabelCollection() {
		return this.fieldLabelCollection;
	}
	
	/**
	 * 设置域对象
	 * @param domain 域对象
	 */
	public void setDomain(MetaDomain domain) {
		this.domain = domain;
	}
	
	/**
	 * 获取域对象
	 * @return 域对象
	 */
	public MetaDomain getDomain() {
		return this.domain;
	}
	
	public IMetaProject getProject() {
		return project;
	}

	public void setProject(IMetaProject project) {
		this.project = project;		
	}
	
	/**
	 * 系统生成标志
	 *
	 * @param autoGen
	 *            标志
	 */
	public void setAutoGen(boolean autoGen) {
		this.autoGen = autoGen;
	}

	@Override
	public boolean isAutoGen() {
		return this.autoGen;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( this.fieldLabelCollection != null ) {
			fieldLabelCollection.getChildMetaObjects(list);
		}
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if( MetaFieldLabelCollection.TAG_NAME.equals(tagName) ) {
			if(fieldLabelCollection == null){	
				fieldLabelCollection = new MetaFieldLabelCollection();
			}
			resultMetaObject = fieldLabelCollection;			
		}
		return resultMetaObject;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		if(domainKey == null || domainKey.isEmpty()) {
			return;
		}
		
		if(callback != null) {
			try {
				callback.call(this);
			} catch (Throwable e) {
				throw new RuntimeException(e);
			}
		}
		
		if(domain != null) {
			checkValid();
			MetaAnnotationUtil.mergeProperty(this, domain);
		}
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaDataElement newObject = new MetaDataElement();
	    newObject.setKey(key);
	    newObject.setCaption(caption);
	    newObject.setDomainKey(domainKey);
	    newObject.setDataType(dataType);
	    newObject.setPrecision(precision);
	    newObject.setScale(scale);
	    newObject.setLength(length);
	    newObject.setParamID(paramID);
	    newObject.setDefaultCaption(defaultCaption);
	    newObject.setDataDiffLog(dataDiffLog);
	    newObject.setNoHistory(noHistory);
	    newObject.setFieldLabelCollection(fieldLabelCollection == null ? null : (MetaFieldLabelCollection)fieldLabelCollection.clone());
		newObject.setDomain(domain);
		newObject.setProject(project);
		newObject.setAutoGen(autoGen);
	    return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDataElement();
	}
	
	private void checkValid() {
		if(domainKey == null || domainKey.isEmpty()) {
			return;
		}
		if(dataType != null && dataType > 0) {
    		throw new MetaException(MetaException.ATTRIBUTE_CONFLICT, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.AttributeConflict), MetaConstants.DATAELEMENT_DOMAINKEY, MetaConstants.DATAELEMENT_DATATYPE));             

		}
		
		if(length != null && length > 0) {
    		throw new MetaException(MetaException.ATTRIBUTE_CONFLICT, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.AttributeConflict), MetaConstants.DATAELEMENT_DOMAINKEY, MetaConstants.DATAELEMENT_LENGTH));             

		}
		
		if(precision != null && precision > 0) {
    		throw new MetaException(MetaException.ATTRIBUTE_CONFLICT, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.AttributeConflict), MetaConstants.DATAELEMENT_DOMAINKEY, MetaConstants.DATAELEMENT_PRECISION));             

		}
		
		if(scale != null && scale > 0) {
    		throw new MetaException(MetaException.ATTRIBUTE_CONFLICT, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.AttributeConflict), MetaConstants.DATAELEMENT_DOMAINKEY, MetaConstants.DATAELEMENT_SCALE));             

		}
	}
}
