package com.bokesoft.yigo.meta.custom;

import java.io.InputStream;

import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.solution.MetaProject;

/**
 * 自定义配置工厂， 用于读取创建自定义配置。
 * 在setting.xml中定义MetaCustomObjectBuilder
 */
public interface IMetaCustomObjectBuilder {
	
	/**
	 * 获取自定义配置对象
	 * @param in 文件流
	 * @param parent 父节点
	 * @param metaProject 工程key
	 * @param parentPath 父节点相对路径
	 * @param filePath 文件相对路径
	 * @param fileName 文件名
	 * @return 配置对象
	 */
	public KeyPairMetaObject build(InputStream in, Object parent, MetaProject metaProject, String parentPath, String filePath, String fileName);
}
