package com.bokesoft.yigo.meta.commondef.resource;

import java.util.LinkedList;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaIconFontSource extends KeyPairMetaObject {

	/** 标识 */
	private String key;

	/** 来源 */
	private String source;

	private MetaIconFontItemCollection itemCollection;
	// 后期处理
	private String solutionKey;

	public static final String TAG_NAME = "IconFontSource";

	public MetaIconFontSource() {
		super();
		itemCollection = new MetaIconFontItemCollection();
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void setKey(String key) {
		this.key = key;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public void setSolutionKey(String solutionKey) {
		this.solutionKey = solutionKey;
	}

	public String getSolutionKey() {
		return solutionKey;
	}

	public MetaIconFontItemCollection getItemCollection() {
		return itemCollection;
	}
	
	public void setItemCollection(MetaIconFontItemCollection itemCollection) {
		this.itemCollection = itemCollection;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaIconFontSource iconFontSource = (MetaIconFontSource) this.newInstance();
		iconFontSource.setKey(this.key);
		iconFontSource.setSource(this.source);
		iconFontSource.setSolutionKey(this.solutionKey);
		iconFontSource.setItemCollection(itemCollection == null ? null : (MetaIconFontItemCollection) itemCollection.clone());

		return iconFontSource;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		if (tagName.equals(MetaIconFontItem.TAG_NAME)) {
			MetaIconFontItem item = new MetaIconFontItem();
			item.preProcessMetaObject(env, doc, node, flag, runType);
			itemCollection.add(item);
			return item;
		}
		return null;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if (callback != null) {
			try {
				callback.call(this);
			} catch (Throwable e) {
			    LogSvr.getInstance().error("IconFontSource "+ this.key + " error", e);
			}
		}
	}


	@Override
	public void getChildMetaObjects(LinkedList<Object> arg0) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaIconFontSource();
	}

}
