package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.TableStatementType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaStatement extends AbstractMetaObject {
	/** 是否动态内容 */
	private boolean dynamic = false;
	/** 内容 */
	private String content = "";
	/** 数据库类型 */
	private String dbType = "";
	/** statement类型,默认为sql */
	private Integer type= TableStatementType.SQL;
	
	public MetaStatement() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "Statement";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置是否动态内容
	 * @param dynamic 是否动态内容标志
	 */
	public void setDynamic(boolean dynamic) {
		this.dynamic = dynamic;
	}
	
	/**
	 * 取得是否动态内容
	 * @return 动态内容标志
	 */
	public boolean isDynamic() {
		return this.dynamic;
	}
	
	/**
	 * 设置内容
	 * @param content 内容
	 */
	public void setContent(String content) {
		this.content = content;
	}
	
	/**
	 * 取得内容
	 * @return 内容
	 */
	public String getContent() {
		return this.content;
	}

	/**
	 * 取得数据库类型 
	 * @return 数据库类型 
	 */
	public String getDBType() {
		return dbType;
	}

	/**
	 * 设置数据库类型 
	 * @param dbType 数据库类型
	 */
	public void setDBType(String dbType) {
		this.dbType = dbType;
	}
	
	/**
	 * 获取statement类型
	 * @return
	 */
	public Integer getType() {
		return type;
	}

	/**
	 * 设置statement类型
	 * @param type
	 */
	public void setType(Integer type) {
		this.type = type;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaStatement newObject = new MetaStatement();
		newObject.setContent(content);
		newObject.setDynamic(dynamic);
		newObject.setDBType(dbType);
		newObject.setType(type);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaStatement();
	}

}
