package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaMigrationExtension extends KeyPairMetaObject {
	public static final String TAG_NAME = "MigrationExtension";
	
	/** 扩展信息的标识 */
	private String key = "";
	/** 扩展信息的分组字段 */
	private String groupFields = "";
	/** 分组字段的list表示*/
	private String[] arrGroupField = null;
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	public String getGroupFields() {
		return groupFields;
	}

	public void setGroupFields(String groupFields) {
		this.groupFields = groupFields;
		arrGroupField = StringUtil.split(groupFields, ";");
	}

	@Override
	public String getKey() {
		return key;
	}
	
	public void setKey(String key) {
		this.key = key;
	}

	public boolean isGroupField(String key) {
		if (arrGroupField == null || arrGroupField.length == 0) {
			return true;
		}

		for (String fieldKey : arrGroupField) {
			if (fieldKey.equals(key)) {
				return true;
			}
		}

		return false;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaMigrationExtension newObject = (MetaMigrationExtension)newInstance();
		newObject.setKey(key);
		newObject.setGroupFields(groupFields);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMigrationExtension();
	}

}
