package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * sap中FieldLabel分为 Short Medium Long Header(表格)
 * @author zhufw
 *
 */
public class MetaFieldLabel extends KeyPairMetaObject {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/** 标识 {@link com.bokesoft.yigo.common.def.FieldLabelType}*/
	private String key = "";
	/** 长度 */
	private Integer length = 0;
	/** 内容 */
	private String text = null;

	@Override
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置字段标签标识
	 * @param key 字段标签标识	
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	public Integer getLength() {
		return this.length;
	}
	
	public void setLength(Integer length) {
		this.length = length;
	}
	
	public String getText() {
		return this.text;
	}
	
	public void setText(String text) {
		this.text = text;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "FieldLabel";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaFieldLabel newObject = new MetaFieldLabel();
		newObject.setKey(key);
		newObject.setLength(length);
		newObject.setText(text);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFieldLabel();
	}
}
