package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaCustomConditionPara定义定制查询条件中用到的参数，如下
 * <ul>
 * <li>Key 标识
 * <li>Formula 值的来源公式
 * </ul>
 * @author wangyh
 *
 */
public class MetaCustomConditionPara extends AbstractMetaObject {
	/** 标识 */
	private String key = "";
	/** 公式 */
	private String formula = "";
	
	public MetaCustomConditionPara() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "CustomConditionPara";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCustomConditionPara newObject = (MetaCustomConditionPara)newInstance();
		newObject.setKey(key);
		newObject.setFormula(formula);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCustomConditionPara();
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置公式
	 * @param formula 公式
	 */
	public void setFormula(String formula) {
		this.formula = formula;
	}
	
	/**
	 * 取得公式
	 * @return 公式
	 */
	public String getFormula() {
		return this.formula;
	}
}
