package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaConditionTarget extends AbstractMetaObject {
	public static final String TAG_NAME = "ConditionTarget";
	
	/** 条件关联的数据表标识 */
	private String tableKey = "";
	/** 条件关联的数据列标识 */
	private String columnKey = "";
	/** 条件的目标 */
	private String target = "";
	
	/**
	 * 取得关联表标识
	 * @return 表标识
	 */
	public String getTableKey() {
		return tableKey;
	}

	/**
	 * 取得关联列标识
	 * @return 列标识
	 */
	public String getColumnKey() {
		return columnKey;
	}

	/**
	 * 设置关联表标识
	 * @param tableKey 表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	/**
	 * 设置关联列标识
	 * @param columnKey 列标识
	 */
	public void setColumnKey(String columnKey) {
		this.columnKey = columnKey;
	}
	
	/**
	 * 设置条件的目标
	 * @param target 目标标识，比如Table1.Column1
	 */
	public void setTarget(String target) {
		this.target = target;
	}
	
	/**
	 * 取得条件的目标
	 * @return 目标标识
	 */
	public String getTarget() {
		return this.target;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaConditionTarget newObject = new MetaConditionTarget();
		newObject.setTableKey(tableKey);
		newObject.setColumnKey(columnKey);
		newObject.setTarget(target);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaConditionTarget();
	}
}
