package com.bokesoft.yigo.meta.businessdiagram;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.intf.IMetaProject;

public class MetaBusinessDiagram extends KeyPairMetaObject {
	
	public static final String TAG_NAME = "BusinessDiagram";

	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	
	private Boolean showStatusSymbo = true;
	
	/** 节点集合 */
	private MetaBusinessDiagramNodeCollection nodeCollection = null;
	/** 线集合 */
	private MetaBusinessDiagramLineCollection lineCollection = null;

	/** 映射所在的工程*/
	private IMetaProject project = null;
	
	@Override
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { nodeCollection, lineCollection});
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (MetaBusinessDiagramNodeCollection.TAG_NAME.equals(tagName)) {
			nodeCollection = new MetaBusinessDiagramNodeCollection();
			child = nodeCollection;
		} else if (MetaBusinessDiagramLineCollection.TAG_NAME.equals(tagName)) {
			lineCollection = new MetaBusinessDiagramLineCollection();
			child = lineCollection;
		}

		if (child != null) {
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}

		return child;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaBusinessDiagram newBusinessDiagram = new MetaBusinessDiagram();
		newBusinessDiagram.setKey(key);
		newBusinessDiagram.setCaption(caption);
		newBusinessDiagram.setNodeCollection(nodeCollection == null ? null : (MetaBusinessDiagramNodeCollection) nodeCollection.clone());
		newBusinessDiagram.setLineCollection(lineCollection == null ? null : (MetaBusinessDiagramLineCollection) lineCollection.clone());

		return newBusinessDiagram;
	}

	public void setNodeCollection(MetaBusinessDiagramNodeCollection nodeCollection) {
		this.nodeCollection = nodeCollection;
	}
	
	public MetaBusinessDiagramNodeCollection getNodeCollection() {
		return this.nodeCollection;
	}

	public void setLineCollection(MetaBusinessDiagramLineCollection lineCollection) {
		this.lineCollection = lineCollection;
	}
	
	public MetaBusinessDiagramLineCollection getLineCollection() {
		return this.lineCollection;
	}
	
	public void addLine(MetaBusinessDiagramLine line) {
		if (lineCollection == null) {
			lineCollection = new MetaBusinessDiagramLineCollection();
		}
		lineCollection.add(line);
	}

	public void addNode(MetaBusinessDiagramNode node) {
		if (nodeCollection == null) {
			nodeCollection = new MetaBusinessDiagramNodeCollection();
		}
		nodeCollection.add(node);
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBusinessDiagram();
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	public Boolean isShowStatusSymbo() {
		return showStatusSymbo;
	}

	public void setShowStatusSymbo(Boolean showStatusSymbo) {
		this.showStatusSymbo = showStatusSymbo;
	}


	public IMetaProject getProject() {
		return project;
	}

	public void setProject(IMetaProject project) {
		this.project = project;
	}
}
