package com.bokesoft.yigo.meta.bpm.process.perm;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map.Entry;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaOptPerm extends GenericKeyCollection<MetaOptPermItem> {

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "OptPerm";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaOptPermItem.TAG_NAME.equals(tagName) ) {
			MetaOptPermItem permItem = new MetaOptPermItem();
			permItem.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(permItem);
			resultMetaObject = permItem;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaOptPerm();
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = new JSONObject();
		JSONArray optPermArray = new JSONArray();
		Iterator<Entry<String, MetaOptPermItem>> it = this.elementMap.entrySet().iterator();
		Entry<String, MetaOptPermItem> entry = null;
		MetaOptPermItem optPerm = null;
		while ( it.hasNext() ) {
			entry = it.next();
			optPerm = entry.getValue();
			optPermArray.put(optPerm.toJSON());
		}
		obj.put("items", optPermArray);
		
		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		if ( json.has("items") ) {
			JSONArray optPermArray = json.getJSONArray("items");
			for ( int i = 0, size = optPermArray.length(); i<size; ++i ) {
				JSONObject optPermObj = optPermArray.getJSONObject(i);
				MetaOptPermItem optPermItem = new MetaOptPermItem();
				optPermItem.fromJSON(optPermObj);
				this.add(optPermItem);
			}
		}
	}

}
