package com.bokesoft.yigo.meta.bpm.process.perm;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map.Entry;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaEnablePerm extends GenericKeyCollection<MetaEnablePermItem> {

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "EnablePerm";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaEnablePermItem.TAG_NAME.equals(tagName) ) {
			MetaEnablePermItem permItem = new MetaEnablePermItem();
			permItem.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(permItem);
			resultMetaObject = permItem;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaEnablePerm();
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = new JSONObject();
		JSONArray enablePermArray = new JSONArray();
		Iterator<Entry<String, MetaEnablePermItem>> it = this.elementMap.entrySet().iterator();
		Entry<String, MetaEnablePermItem> entry = null;
		MetaEnablePermItem enablePerm = null;
		while ( it.hasNext() ) {
			entry = it.next();
			enablePerm = entry.getValue();
			enablePermArray.put(enablePerm.toJSON());
		}
		obj.put("items", enablePermArray);
		
		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		if ( json.has("items") ) {
			JSONArray enablePermArray = json.getJSONArray("items");
			for ( int i = 0, size = enablePermArray.length(); i<size; ++i ) {
				JSONObject enablePermObj = enablePermArray.getJSONObject(i);
				MetaEnablePermItem enablePermItem = new MetaEnablePermItem();
				enablePermItem.fromJSON(enablePermObj);
				this.add(enablePermItem);
			}
		}
	}

}
