package com.bokesoft.yigo.meta.bpm.process.node;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAssistanceCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAutoCommitItemCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAutoIgnoreExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaCreateTriggerExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaFinishTriggerExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaOperationCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaParticipatorCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaParticipatorGroupCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerItemCollection;
import com.bokesoft.yigo.meta.bpm.process.message.MetaNodeMessage;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPerm;

public class MetaUserTask extends MetaNode {

	/** 节点的标签 */
	public final static String TAG_NAME = "UserTask";

	/** 工作项创建事件 */
	private String createTrigger = "";

	/** 工作项完成事件 */
	private String finishTrigger = "";

	/** 关联表单的标识*/
	private String formKey = "";
	
	/** 单据状态标识 */
	private String status = "";
	
	/** 无参者是否自动略过 */
	private Boolean autoIgnoreNoParticipator = false;
	
	/** 同上一步操作员相同是否自动提交*/
	private Boolean autoCommitSameParticipator = false;
	
	/** 包含上一步操作员是否自动提交*/
	private Boolean autoCommitContainSameParticipator = false;

	/** 可用界面操作的集合 */
	protected MetaOperationCollection operationCollection = new MetaOperationCollection();

	/** 辅助节点的集合 */
	protected MetaAssistanceCollection assistanceCollection = new MetaAssistanceCollection();

	/** 参与者的集合 */
	protected MetaParticipatorCollection participatorCollection = new MetaParticipatorCollection();
	
	/** 参与者组集合*/
	protected MetaParticipatorGroupCollection participatorGroupCollection = new MetaParticipatorGroupCollection();

	/** 超时定义的集合 */
	protected MetaTimerItemCollection timerItemCollection = new MetaTimerItemCollection();

	/** 权限设置 */
	private MetaPerm perm = new MetaPerm();
	
	/** 消息设置*/
	private MetaNodeMessage nodeMessage = new MetaNodeMessage();
	
	/** 自动提交的集合*/
	private MetaAutoCommitItemCollection autoCommitItemCollection = new MetaAutoCommitItemCollection();
	
	/** 工作项创建事件的外部资源*/
	private MetaCreateTriggerExternalLink createTriggerExternalLink = new MetaCreateTriggerExternalLink();
	
	/** 工作项完成事件的外部资源*/
	private MetaFinishTriggerExternalLink finishTriggerExternalLink = new MetaFinishTriggerExternalLink();
	
	/** 无参者是否自动略过的外部资源*/
	private MetaAutoIgnoreExternalLink autoIgnoreExternalLink = null;

	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		list.add(operationCollection);
		list.add(assistanceCollection);
		list.add(participatorCollection);
		list.add(timerItemCollection);
		list.add(perm);
		list.add(nodeMessage);
		list.add(autoCommitItemCollection);
		list.add(createTriggerExternalLink);
		list.add(finishTriggerExternalLink);
		list.add(autoIgnoreExternalLink);
	}

	/**
	 * @return the participatorCollection
	 */
	public MetaParticipatorCollection getParticipatorCollection() {
		return participatorCollection;
	}
	
	public void setParticipatorCollection(MetaParticipatorCollection participatorCollection) {
		this.participatorCollection = participatorCollection;
	}
	
	public MetaParticipatorGroupCollection getParticipatorGroupCollection() {
		return participatorGroupCollection;
	}

	public void setParticipatorGroupCollection(MetaParticipatorGroupCollection participatorGroupCollection) {
		this.participatorGroupCollection = participatorGroupCollection;
	}
	
	/**
	 * @return the timerItemCollection
	 */
	public MetaTimerItemCollection getTimerItemCollection() {
		return timerItemCollection;
	}
	
	/**
	 * 设置超时定义集合
	 * @param timerItemCollection 超时定义集合
	 */
	public void setTimerItemCollection(MetaTimerItemCollection timerItemCollection) {
		this.timerItemCollection = timerItemCollection;
	}

	/**
	 * 取得操作定义集合
	 * @return 操作定义集合
	 */
	public MetaOperationCollection getOperationCollection() {
		return operationCollection;
	}
	
	/**
	 * 设置操作定义集合
	 * @param operationCollection 操作定义集合
	 */
	public void setOperationCollection(MetaOperationCollection operationCollection) {
		this.operationCollection = operationCollection;
	}

	/**
	 * @return the assistanceCollection
	 */
	public MetaAssistanceCollection getAssistanceCollection() {
		return assistanceCollection;
	}
	
	/**
	 * 设置辅助节点集合
	 * @param assistanceCollection 辅助节点集合 
	 */
	public void setAssistanceCollection(MetaAssistanceCollection assistanceCollection) {
		this.assistanceCollection = assistanceCollection;
	}

	/**
	 * 取得任务创建触发器
	 * @return 任务创建触发器
	 */
	public String getCreateTrigger() {
		return createTrigger;
	}

	/**
	 * 设置任务创建触发器
	 * @param createTrigger 任务创建触发器
	 */
	public void setCreateTrigger(String createTrigger) {
		this.createTrigger = createTrigger;
	}
	
	public String getStatus(){
		return status;
	}
	
	public void setStatus(String status){
		this.status = status;
	}

	/**
	 * 取得任务完成触发器
	 * @return 任务完成触发器
	 */
	public String getFinishTrigger() {
		return finishTrigger;
	}

	/**
	 * 设置任务完成触发器
	 * @param finishTrigger 任务完成触发器
	 */
	public void setFinishTrigger(String finishTrigger) {
		this.finishTrigger = finishTrigger;
	}

	public String getFormKey() {
		return formKey;
	}
	
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	/**
	 * 取得是否自动略过无参与者任务标志
	 * @return 是否自动略过无参与者任务标志
	 */
	public Boolean isAutoIgnoreNoParticipator() {
		return autoIgnoreNoParticipator;
	}

	/**
	 * 设置是否自动略过无参与者任务
	 * @param autoIgnoreNoParticipator 是否自动略过无参与者任务标志
	 */
	public void setAutoIgnoreNoParticipator(Boolean autoIgnoreNoParticipator) {
		this.autoIgnoreNoParticipator = autoIgnoreNoParticipator;
	}
	
	/**
	 * 取得同上一步操作员相同时是否自动提交
	 * @return 标志
	 */
	public Boolean isAutoCommitSameParticipator() {
		return autoCommitSameParticipator;
	}
	
	/**
	 * 设置同上一步操作员相同时是否自动提交
	 * @param autoCommitSameParticipator 标志
	 */
	public void setAutoCommitSameParticipator(Boolean autoCommitSameParticipator) {
		this.autoCommitSameParticipator = autoCommitSameParticipator;
	}
	
	public Boolean isAutoCommitContainSameParticipator() {
		return autoCommitContainSameParticipator;
	}
	
	public void setAutoCommitContainSameParticipator(Boolean autoCommitContainSameParticipator) {
		this.autoCommitContainSameParticipator = autoCommitContainSameParticipator;
	}
	
	/**
	 * 取得权限配置对象
	 * @return 权限配置对象
	 */
	public MetaPerm getPerm() {
		return perm;
	}

	/**
	 * 设置权限配置对象
	 * @param perm 权限配置对象
	 */
	public void setPerm(MetaPerm perm) {
		this.perm = perm;
	}
	
	public void setNodeMessage(MetaNodeMessage nodeMessage) {
		this.nodeMessage = nodeMessage;
	}
	
	public MetaNodeMessage getNodeMessage() {
		return nodeMessage;
	}
	
	public void setAutoCommitItemCollection(MetaAutoCommitItemCollection autoCommitItemCollection) {
		this.autoCommitItemCollection = autoCommitItemCollection;
	}
	
	public MetaAutoCommitItemCollection getMetaAutoCommitItemCollection() {
		return autoCommitItemCollection;
	}
	
	public void setCreateTriggerExternalLink(MetaCreateTriggerExternalLink createTriggerExternalLink) {
		this.createTriggerExternalLink = createTriggerExternalLink;
	}
	
	public MetaCreateTriggerExternalLink getCreateTriggerExternalLink() {
		return createTriggerExternalLink;
	}
	
	public void setFinishTriggerExternalLink(MetaFinishTriggerExternalLink finishTriggerExternalLink) {
		this.finishTriggerExternalLink = finishTriggerExternalLink;
	}
	
	public MetaFinishTriggerExternalLink getFinishTriggerExternalLink() {
		return finishTriggerExternalLink;
	}
	
	public void setAutoIgnoreExternalLink(MetaAutoIgnoreExternalLink autoIgnoreExternalLink){
		this.autoIgnoreExternalLink = autoIgnoreExternalLink;
	}
	
	public MetaAutoIgnoreExternalLink getAutoIgnoreExternalLink(){
		return autoIgnoreExternalLink;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getNodeType() {
		return NodeType.USER_TASK;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (child != null)
			return child;
		if (tagName.equalsIgnoreCase(MetaOperationCollection.TAG_NAME)) {
			operationCollection = new MetaOperationCollection();
			child = operationCollection;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaAssistanceCollection.TAG_NAME)) {
			assistanceCollection = new MetaAssistanceCollection();
			child = assistanceCollection;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaParticipatorCollection.TAG_NAME)) {
			participatorCollection = new MetaParticipatorCollection();
			child = participatorCollection;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaTimerItemCollection.TAG_NAME)) {
			timerItemCollection = new MetaTimerItemCollection();
			child = timerItemCollection;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaPerm.TAG_NAME)) {
			perm = new MetaPerm();
			child = perm;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaNodeMessage.TAG_NAME)) {
			nodeMessage = new MetaNodeMessage();
			child = nodeMessage;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaAutoCommitItemCollection.TAG_NAME)) {
			autoCommitItemCollection = new MetaAutoCommitItemCollection();
			child = autoCommitItemCollection;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaCreateTriggerExternalLink.TAG_NAME)) {
			createTriggerExternalLink = new MetaCreateTriggerExternalLink();
			child = createTriggerExternalLink;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaFinishTriggerExternalLink.TAG_NAME)) {
			finishTriggerExternalLink = new MetaFinishTriggerExternalLink();
			child = finishTriggerExternalLink;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaAutoIgnoreExternalLink.TAG_NAME)) {
			autoIgnoreExternalLink = new MetaAutoIgnoreExternalLink();
			child = autoIgnoreExternalLink;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaParticipatorGroupCollection.TAG_NAME)) {
			participatorGroupCollection = new MetaParticipatorGroupCollection();
			child = participatorGroupCollection;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return child;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaUserTask newUserTask = (MetaUserTask) super.clone();
		newUserTask.setCreateTrigger(createTrigger);
		newUserTask.setFinishTrigger(finishTrigger);
		newUserTask.setFormKey(formKey);
		newUserTask.setStatus(status);
		newUserTask.setAutoIgnoreNoParticipator(autoIgnoreNoParticipator);
		newUserTask.setAutoCommitSameParticipator(autoCommitSameParticipator);
		newUserTask.setAutoCommitContainSameParticipator(autoCommitContainSameParticipator);
		newUserTask.setOperationCollection(operationCollection == null ? null : (MetaOperationCollection) operationCollection.clone());
		newUserTask.setAssistanceCollection(assistanceCollection == null ? null : (MetaAssistanceCollection) assistanceCollection.clone());
		newUserTask.setParticipatorCollection(participatorCollection == null ? null : (MetaParticipatorCollection) participatorCollection.clone());
		newUserTask.setTimerItemCollection(timerItemCollection == null ? null : (MetaTimerItemCollection) timerItemCollection.clone());
		newUserTask.setNodeMessage(nodeMessage == null ? null : (MetaNodeMessage) nodeMessage.clone());
		newUserTask.setAutoCommitItemCollection(autoCommitItemCollection == null ? null : (MetaAutoCommitItemCollection) autoCommitItemCollection.clone());
		newUserTask.setCreateTriggerExternalLink(createTriggerExternalLink == null ? null : (MetaCreateTriggerExternalLink)createTriggerExternalLink.clone());
		newUserTask.setFinishTriggerExternalLink(finishTriggerExternalLink == null ? null : (MetaFinishTriggerExternalLink)finishTriggerExternalLink.clone());
		newUserTask.setAutoIgnoreExternalLink(autoIgnoreExternalLink == null ? null : (MetaAutoIgnoreExternalLink)autoIgnoreExternalLink.clone());
		return newUserTask;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaUserTask();
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = super.toJSON();
		obj.put("createtrigger", createTrigger);
		obj.put("finishtrigger", finishTrigger);
		obj.put("formkey", formKey);
		obj.put("status", status);
		obj.put("autoignore", autoIgnoreNoParticipator);
		obj.put("autocommit", autoCommitSameParticipator);
		obj.put("autoCommitContain", autoCommitContainSameParticipator);

		if (operationCollection != null) {
			obj.put("operations", operationCollection.toJSON());
		}
		if (assistanceCollection != null) {
			obj.put("assistances", assistanceCollection.toJSON());
		}
		if (participatorCollection != null) {
			obj.put("participators", participatorCollection.toJSON());
		}

		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		createTrigger = json.getString("createtrigger");
		finishTrigger = json.getString("finishtrigger");
		formKey = json.getString("formkey");
		status = json.getString("status");
		autoIgnoreNoParticipator = json.getBoolean("autoignore");
		autoCommitSameParticipator = json.getBoolean("autocommit");
		autoCommitContainSameParticipator = json.getBoolean("autoCommitContain");

		if (json.has("operations")) {
			operationCollection = new MetaOperationCollection();
			operationCollection.fromJSON(json.getJSONObject("operations"));
		}
		if (json.has("assistances")) {
			assistanceCollection = new MetaAssistanceCollection();
			assistanceCollection.fromJSON(json.getJSONObject("assistances"));
		}
		if (json.has("participators")) {
			participatorCollection = new MetaParticipatorCollection();
			participatorCollection.fromJSON(json.getJSONObject("participators"));
		}
	}

}
