package com.bokesoft.yigo.meta.bpm.process.node;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.process.attribute.type.SyncMode;

/**
 * 子流程节点
 * 
 * @author 刘翔翔
 *
 */
public class MetaSubProcess extends MetaUserTask {

	public final static String TAG_NAME = "SubProcess";

	/** 同步模式 */
	private Integer syncMode = SyncMode.SYNC;

	/** 中间层自动创建子流程动作 */
	private String autoStartAction = "";

	/** 子流程流程KEY */
	private String subProcessKey = "";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getNodeType() {
		return NodeType.SUB_PROCESS;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSubProcess();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSubProcess newSubProcess = (MetaSubProcess) super.clone();
		newSubProcess.setSyncMode(syncMode);
		newSubProcess.setAutoStartAction(autoStartAction);
		newSubProcess.setSubProcessKey(subProcessKey);
		return newSubProcess;
	}

	public Integer getSyncMode() {
		return syncMode;
	}

	public void setSyncMode(Integer syncMode) {
		this.syncMode = syncMode;
	}

	public String getAutoStartAction() {
		return autoStartAction;
	}

	public void setAutoStartAction(String autoStartAction) {
		this.autoStartAction = autoStartAction;
	}

	public String getSubProcessKey() {
		return subProcessKey;
	}

	public void setSubProcessKey(String subProcessKey) {
		this.subProcessKey = subProcessKey;
	}
	
	@Override
	public JSONObject toJSON() {
		JSONObject obj = super.toJSON();
		obj.put("sync-mode", syncMode);
		obj.put("auto-start-action", autoStartAction);
		obj.put("sub-process-key", subProcessKey);
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		this.syncMode = json.optInt("sync-mode");
		this.autoStartAction = json.optString("auto-start-action");
		this.subProcessKey = json.optString("sub-process-key");
	}
}
