package com.bokesoft.yigo.meta.bpm.process.monitor;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaLogger extends KeyPairMetaObject {
	public final static String TAG_NAME = "Logger";
	/** 记录器标识*/
	private String key = "";
	/** 是否采用默认*/
	private Boolean useDefault = false;
	/** 自定义日志记录器实现类全路径名*/
	private String provider = "";
	
	/**
	 * 取得记录器标识
	 * 
	 * @return 记录器标识
	 */
	public String getKey() {
		return key;
	}

	/**
	 * 设置记录器标识
	 * 
	 * @param key
	 *            记录器标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	
	public Boolean isUseDefault() {
		return useDefault;
	}

	public void setUseDefault(Boolean useDefault) {
		this.useDefault = useDefault;
	}

	/**
	 * 取得自定义日志记录器实现类全路径名
	 * 
	 * @return 自定义日志记录器实现类全路径名
	 */
	public String getProvider() {
		return provider;
	}

	/**
	 * 设置自定义日志记录器实现类全路径名
	 * 
	 * @param provider
	 *            自定义日志记录器实现类全路径名
	 */
	public void setProvider(String provider) {
		this.provider = provider;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaLogger newLogger = (MetaLogger) newInstance();
		newLogger.setKey(key);
		newLogger.setUseDefault(useDefault);
		newLogger.setProvider(provider);

		return newLogger;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaLogger();
	}

}
