package com.bokesoft.yigo.meta.bpm.process.message;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaMessage extends AbstractMetaObject {
	public static final String TAG_NAME = "Message";
	
	/** 消息的目的地*/
	private String destination="";
	/** 默认发送的消息内容*/
	private String defaultMessage = "";
	/** 自定义生成消息的接口实现类全路径名，可自定义消息主体；若该属性定义了，则DefaultMessage无效*/
	private String generatorImpl="";
	/** 自定义实现消息发送接口的类全路径名；若定义了该属性，则GeneratorImpl无效*/
	private String sendImpl="";
	/** 重发次数*/
	private Integer resendTimes = 0;
	/** 消息超时时间*/
	private Long timeout = -1L;

	public String getDestination() {
		return destination;
	}

	public void setDestination(String destination) {
		this.destination = destination;
	}
	
	public Integer getResendTimes() {
		return resendTimes;
	}
	
	public void setResendTimes(Integer resendTimes) {
		this.resendTimes = resendTimes;
	}
	
	public Long getTimeout() {
		return timeout;
	}
	
	public void setTimeout(Long timeout) {
		this.timeout = timeout;
	}

	public String getDefaultMessage() {
		return defaultMessage;
	}

	public void setDefaultMessage(String defaultMessage) {
		this.defaultMessage = defaultMessage;
	}

	public String getGeneratorImpl() {
		return generatorImpl;
	}

	public void setGeneratorImpl(String generatorImpl) {
		this.generatorImpl = generatorImpl;
	}

	public String getSendImpl() {
		return sendImpl;
	}

	public void setSendImpl(String sendImpl) {
		this.sendImpl = sendImpl;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaMessage obj = (MetaMessage) newInstance();
		obj.destination = destination;
		obj.defaultMessage = defaultMessage;
		obj.generatorImpl = generatorImpl;
		obj.sendImpl = sendImpl;
		return obj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMessage();
	}

}
