package com.bokesoft.yigo.meta.bpm.process.event;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourceParaCollection;

public class MetaEventCollectionExternalLink extends MetaEventItem {

	public static final String TAG_NAME = "EventCollectionExternalLink";
	
	private MetaSourceParaCollection metaSourceParaCollection = null;
	
	public void setSourceParaCollection(MetaSourceParaCollection metaSourceParaCollection) {
		this.metaSourceParaCollection = metaSourceParaCollection;
	}
	
	public MetaSourceParaCollection getSourceParaCollection() {
		return metaSourceParaCollection;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { metaSourceParaCollection });

	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (resultMetaObject != null)
			return resultMetaObject;
		if (tagName.equalsIgnoreCase(MetaSourceParaCollection.TAG_NAME)) {
			metaSourceParaCollection = new MetaSourceParaCollection();
			resultMetaObject = metaSourceParaCollection;
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaEventCollectionExternalLink meta = (MetaEventCollectionExternalLink)super.clone();
		meta.setSourceParaCollection(metaSourceParaCollection == null ? null : (MetaSourceParaCollection)metaSourceParaCollection.clone());
		return meta;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaEventCollectionExternalLink();
	}
}
