package com.bokesoft.yigo.meta.bpm.process.data;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaDataItem extends KeyPairMetaObject {
	public static final String TAG_NAME = "DataItem";
	
	private String key = null;
	
	private Boolean fromDefault = false;
	
	private MetaBaseScript content = null;
	
	private Integer dataType = -1;
	
	private Boolean cache = false;
	
	public Boolean isFromDefault() {
		return fromDefault;
	}

	public void setFromDefault(Boolean fromDefault) {
		this.fromDefault = fromDefault;
	}

	public MetaBaseScript getContent() {
		return content;
	}

	public void setContent(MetaBaseScript content) {
		this.content = content;
	}

	public Integer getDataType() {
		return dataType;
	}

	public void setDataType(Integer dataType) {
		this.dataType = dataType;
	}


	public Boolean isCache() {
		return cache;
	}

	public void setCache(Boolean cache) {
		this.cache = cache;
	}

	@Override
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (BPMConstants.DATA_ITEM_CONTENT.equals(tagName)) {
			content = new MetaBaseScript(BPMConstants.DATA_ITEM_CONTENT);
			child = content;
		}
		return child;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDataItem obj = (MetaDataItem) newInstance();
		obj.key = key;
		obj.fromDefault = fromDefault;
		obj.content = content == null ? null :(MetaBaseScript) content.clone();
		obj.dataType = dataType;
		obj.cache = cache;
		return obj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDataItem();
	}

}
