package com.bokesoft.yigo.meta.bpm.process.attribute.participator;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.attribute.parameter.MetaParameterCollections;

public class MetaDynamicParticipatorGroup extends MetaParticipatorGroup {
	public final static String TAG_NAME = "DynamicParticipatorGroup";


	private MetaParameterCollections metaParameterCollections = null;
		
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDynamicParticipatorGroup();
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (tagName.equalsIgnoreCase(MetaParameterCollections.TAG_NAME)) {
			metaParameterCollections = new MetaParameterCollections();
			child = metaParameterCollections;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaParticipatorCollection.TAG_NAME)) {
			participatorCollection = new MetaParticipatorCollection();
			child = participatorCollection;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return child;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaDynamicParticipatorGroup newGroup = (MetaDynamicParticipatorGroup)newInstance();
		newGroup.setMetaParameterCollections(null == metaParameterCollections ? null : (MetaParameterCollections)metaParameterCollections.clone());
		newGroup.setParticipatorCollection(null == participatorCollection ? null : (MetaParticipatorCollection)participatorCollection.clone());
		return newGroup;
	}

	public MetaParameterCollections getMetaParameterCollections() {
		return metaParameterCollections;
	}

	public void setMetaParameterCollections(MetaParameterCollections metaParameterCollections) {
		this.metaParameterCollections = metaParameterCollections;
	}
	
	
}
