package com.bokesoft.yigo.meta.bpm.process.attribute;

import java.util.Iterator;
import java.util.Map.Entry;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.AbstractBPMCollection;

public class MetaSwimlineCollection extends AbstractBPMCollection<MetaSwimline> {

	public final static String TAG_NAME = "SwimlineCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSwimlineCollection();
	}

	@Override
	protected MetaSwimline createChildMetaElement(String tagName) {
		MetaSwimline child = null;
		if (tagName.equalsIgnoreCase(MetaSwimline.TAG_NAME))
			child = new MetaSwimline();
		return child;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = new JSONObject();
		JSONArray swimlineArray = new JSONArray();
		Iterator<Entry<String, MetaSwimline>> it = this.elementMap.entrySet().iterator();
		Entry<String, MetaSwimline> entry = null;
		MetaSwimline swimline = null;
		while ( it.hasNext() ) {
			entry = it.next();
			swimline = entry.getValue();
			swimlineArray.put(swimline.toJSON());
		}
		obj.put("items", swimlineArray);
		
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		if ( json.has("items") ) {
			JSONArray swimlineArray = json.getJSONArray("items");
			for ( int i = 0, size = swimlineArray.length(); i<size; ++i ) {
				JSONObject swimlineObj = swimlineArray.getJSONObject(i);
				MetaSwimline swimline = new MetaSwimline();
				swimline.fromJSON(swimlineObj);
				this.add(swimline);
			}
		}
	}

}
