package com.bokesoft.yigo.meta.bpm.process.attribute;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourceParaCollection;

public class MetaPreCondition extends KeyPairMetaObject {

	public static final String TAG_NAME = "PreCondition";
	
	private String key = "";
	
	private MetaSourceParaCollection metaSourceParaCollection = null;
	
	public void setSourceParaCollection(MetaSourceParaCollection metaSourceParaCollection) {
		this.metaSourceParaCollection = metaSourceParaCollection;
	}
	
	public MetaSourceParaCollection getSourceParaCollection() {
		return metaSourceParaCollection;
	}
	
	@Override
	public String getKey() {
		return key;
	}
	
	public void setKey(String key){
		this.key = key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { metaSourceParaCollection });

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaSourceParaCollection.TAG_NAME)) {
			metaSourceParaCollection = new MetaSourceParaCollection();
			resultMetaObject = metaSourceParaCollection;
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaPreCondition meta = (MetaPreCondition)newInstance();
		meta.setKey(key);
		meta.setSourceParaCollection(metaSourceParaCollection == null ? null : (MetaSourceParaCollection)metaSourceParaCollection.clone());
		return meta;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaPreCondition();
	}

}
