package com.bokesoft.yigo.meta.base;

import java.util.Spliterator;
import java.util.function.Consumer;

import com.bokesoft.yes.common.struct.StringLinkedHashMap;

public abstract class GenericWrapperKeyCollection<T extends AbstractMetaObject> extends
		AbstractMetaObject implements Iterable<T> {

	protected StringLinkedHashMap<WrapperKeyPairMetaObject<T>> elementMap = null;

	public GenericWrapperKeyCollection() {
		elementMap = new StringLinkedHashMap<WrapperKeyPairMetaObject<T>>();
	}

	public T add(WrapperKeyPairMetaObject<T> element) {
		synchronized(elementMap) {
			elementMap.put(element.getKey(), element);
			return element.inner;
		}
	}

	public void remove(String key) {
		synchronized(elementMap) {
			elementMap.remove(key);
		}
	}

	public T get(String key) {
		synchronized(elementMap) {
			WrapperKeyPairMetaObject<T> element = elementMap.get(key);
			return element == null ? null : element.inner;
		}
	}

	public int size() {
		synchronized(elementMap) {
			return elementMap.size();
		}
	}

	@Override
	public void traversalCollectionObjects(IMetaEnv env, Object doc, Object node,
										   Object flag, int runType) throws MetaException {
	}

	/**
	 * 去掉@Override是为了兼容java7和java8
	 */
	public void forEach(Consumer<? super T> action) {
		// TODO Auto-generated method stub

	}

	/**
	 * 去掉@Override是为了兼容java7和java8
	 */
	public Spliterator<T> spliterator() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		return null;
	}

}
